/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.heirlooms;

import com.khazoda.heirlooms.HeirloomsMod;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class CommonTooltipHandler {
    public static final int CRAFTED_TEXT_COLOR = 9068607;
    public static final int ENCHANTED_TEXT_COLOR = 4157834;

    public static void handleTooltip(ItemStack stack, List<Component> tooltip, TooltipFlag flag, boolean isCtrlPressed, boolean isAltPressed) {
        String craftedTimestamp = (String)stack.get(HeirloomsMod.CRAFTED_TIMESTAMP);
        String craftedBy = (String)stack.get(HeirloomsMod.CRAFTED_BY);
        String enchantedTimestamp = (String)stack.get(HeirloomsMod.ENCHANTED_TIMESTAMP);
        String enchantedBy = (String)stack.get(HeirloomsMod.ENCHANTED_BY);
        if (craftedTimestamp == null && enchantedTimestamp == null) {
            return;
        }
        CommonTooltipHandler.addButtonPrompts(tooltip, craftedTimestamp != null, enchantedTimestamp != null, isCtrlPressed, isAltPressed);
        if (craftedTimestamp != null && craftedBy != null && isCtrlPressed) {
            CommonTooltipHandler.addTimestampTooltip(tooltip, craftedTimestamp, craftedBy, "tooltip.heirlooms.crafted_by", 9068607);
        }
        if (enchantedTimestamp != null && enchantedBy != null && isAltPressed) {
            CommonTooltipHandler.addTimestampTooltip(tooltip, enchantedTimestamp, enchantedBy, "tooltip.heirlooms.enchanted_by", 4157834);
        }
    }

    private static void addButtonPrompts(List<Component> tooltip, boolean hasCraftData, boolean hasEnchantData, boolean isCtrlPressed, boolean isAltPressed) {
        MutableComponent buttonPrompt = Component.empty();
        if (hasCraftData && !isCtrlPressed) {
            buttonPrompt.append((Component)Component.literal((String)"[\u1d04\u1d1b\u0280\u029f]").withColor(9068607));
        }
        if (hasCraftData && !isCtrlPressed && hasEnchantData && !isAltPressed) {
            buttonPrompt.append((Component)Component.literal((String)" "));
        }
        if (hasEnchantData && !isAltPressed) {
            buttonPrompt.append((Component)Component.literal((String)"[\u1d00\u029f\u1d1b]").withColor(4157834));
        }
        if (!buttonPrompt.getString().isEmpty()) {
            tooltip.add((Component)buttonPrompt);
        }
    }

    private static void addTimestampTooltip(List<Component> tooltip, String timestamp, String creator, String translationKey, int color) {
        try {
            Instant instant = Instant.parse(timestamp);
            ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
            int year = zonedDateTime.getYear();
            int month = zonedDateTime.getMonthValue();
            int day = zonedDateTime.getDayOfMonth();
            String languageCode = Minecraft.getInstance().getLanguageManager().getSelected();
            Locale locale = Locale.forLanguageTag(languageCode.replace("_", "-"));
            String monthName = zonedDateTime.getMonth().getDisplayName(TextStyle.FULL, locale);
            tooltip.add((Component)Component.translatable((String)translationKey, (Object[])new Object[]{creator}).withColor(color));
            tooltip.add((Component)Component.translatable((String)"tooltip.heirlooms.date", (Object[])new Object[]{CommonTooltipHandler.getFormattedDay(day, locale), month, monthName, year}).withColor(color));
        }
        catch (Exception e) {
            System.out.println("Heirlooms mod error [1] - please report on the issue tracker");
        }
    }

    private static String getFormattedDay(int day, Locale locale) {
        if (locale.getLanguage().equals("en")) {
            String[] suffixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
            return switch (day % 100) {
                case 11, 12, 13 -> day + "th";
                default -> day + suffixes[day % 10];
            };
        }
        return String.valueOf(day);
    }
}

