/*
 * Decompiled with CFR 0.152.
 */
package com.bettersnowiersnow;

import com.bettersnowiersnow.bukkit.Metrics;
import com.bettersnowiersnow.command.ReloadCommand;
import com.bettersnowiersnow.config.Settings;
import com.bettersnowiersnow.event.SnowFallingEvent;
import com.bettersnowiersnow.event.SnowMeltEvent;
import com.bettersnowiersnow.event.SnowPoseEvent;
import com.bettersnowiersnow.event.SnowSlownessEvent;
import com.bettersnowiersnow.event.SnowyGrassDecayEvent;
import com.bettersnowiersnow.event.SnowyGrassSpreadEvent;
import com.bettersnowiersnow.utils.Utilities;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class BetterSnowierSnow
extends JavaPlugin {
    private static BetterSnowierSnow instance;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.reloadConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.registerEvents();
        this.registerTasks();
        if (Settings.metrics) {
            new Metrics(this, 9912);
        }
        Objects.requireNonNull(this.getCommand("reload")).setExecutor((CommandExecutor)new ReloadCommand());
    }

    public void reloadConfig() {
        super.reloadConfig();
        Settings.load();
    }

    public void onDisable() {
        if (Settings.snowPoseTasks != null) {
            Settings.snowPoseTasks.values().forEach(task -> {
                Bukkit.getScheduler().cancelTask(task.getTaskId());
                task.cancel();
            });
        }
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (Settings.snowGravity) {
            pluginManager.registerEvents((Listener)new SnowFallingEvent(), (Plugin)this);
        }
        if (Settings.noSnowyGrassDecay) {
            pluginManager.registerEvents((Listener)new SnowyGrassDecayEvent(), (Plugin)this);
        }
        if (Settings.noSnowyGrassSpread) {
            pluginManager.registerEvents((Listener)new SnowyGrassSpreadEvent(), (Plugin)this);
        }
        if (Settings.slownessOnSnow) {
            pluginManager.registerEvents((Listener)new SnowSlownessEvent(), (Plugin)this);
        }
        pluginManager.registerEvents((Listener)new SnowMeltEvent(), (Plugin)this);
        if (Settings.excludedChunks != null && !Settings.excludedChunks.isEmpty()) {
            pluginManager.registerEvents((Listener)new SnowPoseEvent(), (Plugin)this);
        }
    }

    private void registerTasks() {
        this.getServer().getWorlds().stream().filter(world -> Utilities.getLoadedChunks().stream().anyMatch(chunk -> chunk.getWorld().getName().equalsIgnoreCase(world.getName()))).forEach(world -> Utilities.runSnowPoseTaskForWorld(world.getName()));
    }

    public static BetterSnowierSnow getInstance() {
        return instance;
    }
}

