/*
 * Decompiled with CFR 0.152.
 */
package com.bettersnowiersnow.event;

import com.bettersnowiersnow.utils.Utilities;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Snow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityDropItemEvent;

public class SnowFallingEvent
implements Listener {
    @EventHandler
    public void onSnowFalling(BlockPhysicsEvent event) {
        Snow snowLayer;
        Block block = event.getBlock();
        if (Utilities.isSnowLayer(block) && (snowLayer = (Snow)Utilities.cast(block)).getLayers() == snowLayer.getMaximumLayers()) {
            block.setType(Material.SNOW_BLOCK);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Block blockAbove = block.getRelative(BlockFace.UP);
        if (Utilities.isSnowBlockOrLayer(blockAbove)) {
            Utilities.spawnFallingSnow(blockAbove);
        }
    }

    @EventHandler
    public void onFallingSnowDrop(EntityDropItemEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)entity;
            BlockData fallingBlockData = fallingBlock.getBlockData();
            Material material = fallingBlockData.getMaterial();
            if (material == Material.SNOW_BLOCK || material == Material.POWDER_SNOW) {
                Utilities.dropItemAtEntity((Entity)fallingBlock, Material.SNOWBALL, 2);
            }
            if (material == Material.SNOW) {
                Snow snow = (Snow)fallingBlockData;
                Utilities.increaseSnowLayersAt(fallingBlock.getLocation(), snow.getLayers());
            }
            event.setCancelled(Utilities.isSnowBlockOrLayer(material));
        }
    }
}

