/*
 * Decompiled with CFR 0.152.
 */
package com.bettersnowiersnow.event;

import com.bettersnowiersnow.config.Settings;
import com.bettersnowiersnow.utils.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.weather.WeatherChangeEvent;

public class SnowPoseEvent
implements Listener {
    @EventHandler
    public void onSnowPose(BlockFormEvent event) {
        if (event.getNewState().getType() == Material.SNOW) {
            Chunk chunk = event.getBlock().getChunk();
            event.setCancelled(Utilities.isChunkExcludedForVanilla(chunk));
        }
    }

    @EventHandler
    public void onWeatherChange(WeatherChangeEvent event) {
        if (!event.isCancelled()) {
            String world = event.getWorld().getName();
            if (event.toWeatherState()) {
                Utilities.runSnowPoseTaskForWorld(world);
            } else {
                Utilities.cancelSnowPoseTaskForWorld(world);
            }
        }
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        World world = event.getPlayer().getWorld();
        if (Utilities.isValidWorld(world) && !Settings.snowPoseTasks.containsKey(world.getName())) {
            Utilities.runSnowPoseTaskForWorld(world.getName());
        }
    }

    @EventHandler
    public void onPlayerLogout(PlayerQuitEvent event) {
        if (Bukkit.getOnlinePlayers().size() - 1 == 0) {
            Settings.snowPoseTasks.forEach((world, bukkitTask) -> Utilities.cancelSnowPoseTaskForWorld(world));
            Settings.snowPoseTasks.clear();
        }
    }
}

