/*
 * Decompiled with CFR 0.152.
 */
package com.bettersnowiersnow.task;

import com.bettersnowiersnow.config.Settings;
import com.bettersnowiersnow.utils.Utilities;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Snow;

public class SnowPoseTask
implements Runnable {
    @Override
    public void run() {
        Utilities.getLoadedChunks().forEach(chunk -> {
            Set<Block> blocks;
            if (Utilities.shouldPoseSnow() && (blocks = this.getRandomBlocksAtMinLevel((Chunk)chunk)) != null && !blocks.isEmpty()) {
                blocks.stream().filter(Objects::nonNull).forEach(block -> {
                    int increase = 1;
                    if (!Utilities.isSnowLayer(block)) {
                        block = Utilities.getRelativeBlock(block, BlockFace.UP);
                        block.setType(Material.SNOW);
                        increase = 0;
                    }
                    try {
                        Snow snow = (Snow)Utilities.cast(block);
                        Utilities.increaseSnowLayersFromPosing(block, snow, increase);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        });
    }

    private Set<Block> getRandomBlocksAtMinLevel(Chunk chunk) {
        Set<Block> chunkBlocks = this.getValidChunkBlocks(chunk.getWorld(), chunk.getX(), chunk.getZ());
        int minLevel = chunkBlocks.stream().mapToInt(block -> {
            Block blockAbove = Utilities.getRelativeBlock(block, BlockFace.UP);
            if (Utilities.isSnowLayer(blockAbove)) {
                Snow snow = (Snow)Utilities.cast(blockAbove);
                return snow.getLayers();
            }
            return 0;
        }).min().orElse(0);
        List blockPool = minLevel == 0 ? chunkBlocks.stream().filter(block -> !Utilities.isSnowLayer(Utilities.getRelativeBlock(block, BlockFace.UP))).collect(Collectors.toList()) : chunkBlocks.stream().filter(block -> Utilities.isSnowLayer(Utilities.getRelativeBlock(block, BlockFace.UP))).map(block -> Utilities.getRelativeBlock(block, BlockFace.UP)).filter(block -> {
            Snow snow = (Snow)Utilities.cast(block);
            return snow.getLayers() == minLevel && Utilities.canMoreLayersBePlaced(snow);
        }).collect(Collectors.toList());
        if (blockPool.isEmpty()) {
            return null;
        }
        Collections.shuffle(blockPool);
        return blockPool.stream().limit(Settings.snowPoseBlocks).collect(Collectors.toSet());
    }

    private Set<Block> getValidChunkBlocks(World world, int x, int z) {
        HashSet<Block> chunkBlocks = new HashSet<Block>();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Block startingBlock = world.getHighestBlockAt(i + x * 16, j + z * 16);
                Block highestBlock = Utilities.getRelativeBlock(startingBlock, BlockFace.UP);
                if (Utilities.isSnowLayer(highestBlock) || Utilities.isAir(highestBlock)) {
                    highestBlock = startingBlock;
                }
                chunkBlocks.add(highestBlock);
            }
        }
        return chunkBlocks.stream().filter(block -> Utilities.isInColdBiome(block) && Utilities.isValidMaterial(block) && Utilities.isValidBlockAboveForPose(block)).collect(Collectors.toSet());
    }
}

