/*
 * Decompiled with CFR 0.152.
 */
package com.bettersnowiersnow.config;

import com.bettersnowiersnow.BetterSnowierSnow;
import com.bettersnowiersnow.config.ExcludedChunk;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.scheduler.BukkitTask;

public class Settings {
    private static FileConfiguration CONFIG;
    public static boolean snowGravity;
    public static boolean noMeltInColdBiomes;
    public static int meltAboveLightLevel;
    public static boolean noSnowyGrassDecay;
    public static boolean noSnowyGrassSpread;
    public static boolean slownessOnSnow;
    public static int slownessMinLayers;
    public static int slownessStrength;
    public static boolean slownessSneakingPrevent;
    public static double snowChancePercentage;
    public static int snowPoseFrequency;
    public static List<String> snowPoseWorlds;
    public static int snowPoseMaxLayers;
    public static int snowPoseBlocks;
    public static Set<ExcludedChunk> excludedChunks;
    public static double snowMeltPercentage;
    public static int snowMeltMinLayers;
    public static boolean metrics;
    public static HashMap<String, BukkitTask> snowPoseTasks;

    public static void load() {
        CONFIG = BetterSnowierSnow.getInstance().getConfig();
        snowGravity = Settings.getBoolean("snowGravity");
        noMeltInColdBiomes = Settings.getBoolean("noMeltInColdBiomes");
        meltAboveLightLevel = Math.min(Math.max(0, Settings.getInt("meltAboveLightLevel")), 15);
        noSnowyGrassDecay = Settings.getBoolean("noSnowyGrassDecay");
        noSnowyGrassSpread = Settings.getBoolean("noSnowyGrassSpread");
        slownessOnSnow = Settings.getBoolean("slownessOnSnow");
        slownessMinLayers = Math.min(7, Math.max(0, Settings.getInt("slownessMinLayers")));
        slownessStrength = Settings.getInt("slownessStrength");
        slownessSneakingPrevent = Settings.getBoolean("slownessSneakingPrevent");
        snowChancePercentage = Settings.getDouble("snowChancePercentage");
        snowPoseFrequency = Settings.getInt("snowPoseFrequency");
        snowPoseWorlds = Settings.getStringList("snowPoseWorlds");
        snowPoseMaxLayers = Math.min(7, Math.max(0, Settings.getInt("snowPoseMaxLayers")));
        snowPoseBlocks = Math.min(Math.max(0, Settings.getInt("snowPoseBlocks")), 256);
        excludedChunks = Settings.getExcludedChunks();
        snowMeltPercentage = Settings.getDouble("snowMeltPercentage");
        snowMeltMinLayers = Math.max(0, Math.min(7, Settings.getInt("snowMeltMinLayers")));
        metrics = Settings.getBoolean("metrics");
    }

    private static boolean getBoolean(String key) {
        return CONFIG.getBoolean(key);
    }

    private static int getInt(String key) {
        return CONFIG.getInt(key);
    }

    private static double getDouble(String key) {
        return CONFIG.getDouble(key);
    }

    private static List<String> getStringList(String key) {
        return CONFIG.getStringList(key);
    }

    private static Set<ExcludedChunk> getExcludedChunks() {
        excludedChunks = new HashSet<ExcludedChunk>();
        Settings.getStringList("snowPoseIgnoredChunks").forEach(chunk -> {
            String[] splitChunk = chunk.split(",");
            int fromX = Integer.parseInt(splitChunk[0]);
            int fromZ = Integer.parseInt(splitChunk[1]);
            int toX = Integer.parseInt(splitChunk[2]);
            int toZ = Integer.parseInt(splitChunk[3]);
            boolean preventVanilla = Boolean.parseBoolean(splitChunk[4]);
            excludedChunks.add(new ExcludedChunk(fromX, fromZ, toX, toZ, preventVanilla));
        });
        return excludedChunks;
    }

    static {
        snowPoseTasks = new HashMap();
    }
}

