/*
 * Decompiled with CFR 0.152.
 */
package com.bettersnowiersnow.event;

import com.bettersnowiersnow.config.Settings;
import com.bettersnowiersnow.utils.Utilities;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Snow;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFadeEvent;

public class SnowMeltEvent
implements Listener {
    @EventHandler
    public void onSnowMelt(BlockFadeEvent event) {
        Block block = event.getBlock();
        if (Utilities.isSnowBlockOrLayer(block)) {
            event.setCancelled(true);
            if (Settings.noMeltInColdBiomes && Utilities.isInColdBiome(block) || Utilities.isBelowMinimumLightLevel(block)) {
                return;
            }
            if (Utilities.shouldMeltSnow() && Utilities.isSnowLayer(block)) {
                try {
                    Snow snow = (Snow)Utilities.cast(block);
                    Utilities.decreaseSnowLayersFromMelting(block, snow, 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

