/*
 * Decompiled with CFR 0.152.
 */
package com.bettersnowiersnow.utils;

import com.bettersnowiersnow.BetterSnowierSnow;
import com.bettersnowiersnow.config.ExcludedChunk;
import com.bettersnowiersnow.config.Settings;
import com.bettersnowiersnow.task.SnowPoseTask;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Snow;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class Utilities {
    public static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final BetterSnowierSnow PLUGIN = BetterSnowierSnow.getInstance();
    private static final BukkitScheduler SCHEDULER = Bukkit.getScheduler();
    private static final List<Biome> coldBiomes = Arrays.asList(Biome.DEEP_FROZEN_OCEAN, Biome.FROZEN_OCEAN, Biome.FROZEN_RIVER, Biome.ICE_SPIKES, Biome.SNOWY_BEACH, Biome.FROZEN_PEAKS, Biome.JAGGED_PEAKS, Biome.STONY_PEAKS, Biome.MEADOW, Biome.GROVE, Biome.SNOWY_SLOPES, Biome.SNOWY_TAIGA);

    public static boolean is(Block block, Material material) {
        return block.getType() == material;
    }

    public static boolean isSnowLayer(Block block) {
        return Utilities.is(block, Material.SNOW);
    }

    public static boolean isSnowBlock(Block block) {
        return Utilities.is(block, Material.SNOW_BLOCK) || Utilities.is(block, Material.POWDER_SNOW);
    }

    public static boolean isSnowBlockOrLayer(Block block) {
        return Utilities.isSnowBlock(block) || Utilities.isSnowLayer(block);
    }

    public static boolean isSnowBlockOrLayer(Material material) {
        return material == Material.SNOW_BLOCK || material == Material.SNOW || material == Material.POWDER_SNOW;
    }

    public static Block getRelativeBlock(Block block, BlockFace face) {
        return block.getRelative(face);
    }

    public static boolean isValidMaterialForFalling(Block block) {
        return !block.getType().isAir() && !block.isLiquid();
    }

    public static boolean isSolidFullBlock(Block block) {
        Material material = block.getType();
        return !Utilities.isInvalid(block) && (material.isOccluding() || Utilities.is(block, Material.SCAFFOLDING) || material.isSolid() && (Utilities.isTopOrDoubleSlab(block) || Utilities.isTopStair(block) || Utilities.isTopTrapdoor(block) || Utilities.isFullBlock(block)));
    }

    private static boolean isFullBlock(Block block) {
        return block.getBoundingBox().getVolume() == 1.0 && block.getType().isBlock() && !block.isLiquid() && !block.isPassable();
    }

    private static boolean isInvalid(Block block) {
        return Utilities.isSlab(block) && !Utilities.isTopOrDoubleSlab(block) || Utilities.is(block, Material.HOPPER) || Utilities.is(block, Material.BARRIER) || Utilities.is(block, Material.STRUCTURE_VOID) || Utilities.isIce(block) || Utilities.is(block, Material.CAULDRON) || Utilities.isStair(block) && !Utilities.isTopStair(block) || Utilities.isTrapdoor(block) && !Utilities.isTopTrapdoor(block) || Utilities.isFence(block) || Utilities.isGlassPane(block) || Utilities.is(block, Material.IRON_BARS);
    }

    public static boolean isGlassPane(Block block) {
        return Utilities.is(block, Material.GLASS_PANE) || Utilities.is(block, Material.BLACK_STAINED_GLASS_PANE) || Utilities.is(block, Material.RED_STAINED_GLASS_PANE) || Utilities.is(block, Material.GREEN_STAINED_GLASS_PANE) || Utilities.is(block, Material.YELLOW_STAINED_GLASS_PANE) || Utilities.is(block, Material.BLUE_STAINED_GLASS_PANE) || Utilities.is(block, Material.WHITE_STAINED_GLASS_PANE) || Utilities.is(block, Material.PINK_STAINED_GLASS_PANE) || Utilities.is(block, Material.ORANGE_STAINED_GLASS_PANE) || Utilities.is(block, Material.GRAY_STAINED_GLASS_PANE) || Utilities.is(block, Material.LIGHT_GRAY_STAINED_GLASS_PANE) || Utilities.is(block, Material.LIGHT_BLUE_STAINED_GLASS_PANE) || Utilities.is(block, Material.LIME_STAINED_GLASS_PANE) || Utilities.is(block, Material.PURPLE_STAINED_GLASS_PANE) || Utilities.is(block, Material.BROWN_STAINED_GLASS_PANE) || Utilities.is(block, Material.MAGENTA_STAINED_GLASS_PANE) || Utilities.is(block, Material.CYAN_STAINED_GLASS_PANE);
    }

    private static boolean isTopOrDoubleSlab(Block block) {
        if (Utilities.isSlab(block)) {
            Slab slab = (Slab)Utilities.cast(block);
            return slab.getType() == Slab.Type.TOP || slab.getType() == Slab.Type.DOUBLE;
        }
        return false;
    }

    private static boolean isTopStair(Block block) {
        if (Utilities.isStair(block)) {
            Stairs stairs = (Stairs)Utilities.cast(block);
            return stairs.getHalf() == Bisected.Half.TOP;
        }
        return false;
    }

    private static boolean isTopTrapdoor(Block block) {
        if (Utilities.isTrapdoor(block)) {
            TrapDoor trapDoor = (TrapDoor)Utilities.cast(block);
            return trapDoor.getHalf() == Bisected.Half.TOP && !trapDoor.isOpen();
        }
        return false;
    }

    private static boolean isFence(Block block) {
        return Tag.FENCES.isTagged((Keyed)block.getType()) || Tag.WOODEN_FENCES.isTagged((Keyed)block.getType());
    }

    private static boolean isSlab(Block block) {
        return Tag.SLABS.isTagged((Keyed)block.getType()) || Tag.WOODEN_SLABS.isTagged((Keyed)block.getType());
    }

    private static boolean isStair(Block block) {
        return Tag.STAIRS.isTagged((Keyed)block.getType()) || Tag.WOODEN_STAIRS.isTagged((Keyed)block.getType());
    }

    private static boolean isTrapdoor(Block block) {
        return Tag.TRAPDOORS.isTagged((Keyed)block.getType()) || Tag.WOODEN_TRAPDOORS.isTagged((Keyed)block.getType());
    }

    public static boolean isValidMaterial(Block block) {
        return Utilities.isSnowBlockOrLayer(block) || Utilities.isValidMaterialForFalling(block) && Utilities.isSolidFullBlock(block);
    }

    public static boolean isValidBlockAboveForPose(Block block) {
        Block blockAbove = Utilities.getRelativeBlock(block, BlockFace.UP);
        return Utilities.isValidMaterial(blockAbove) || Utilities.isAir(blockAbove);
    }

    public static boolean isAir(Block block) {
        return block.getType().isAir();
    }

    public static void spawnFallingSnow(Block block) {
        BlockData blockData = block.getBlockData().clone();
        SCHEDULER.runTaskLater((Plugin)PLUGIN, () -> {
            block.setType(Material.AIR);
            Utilities.createFallingBlock(block, blockData);
        }, 2L);
    }

    public static void createFallingBlock(Block block, BlockData blockData) {
        FallingBlock fallingBlock = block.getWorld().spawnFallingBlock(block.getLocation().add(0.5, 0.0, 0.5), blockData);
        fallingBlock.setDropItem(true);
    }

    public static void dropItemAtEntity(Entity entity, Material item, int quantity) {
        Utilities.dropItemAtEntity(entity, new ItemStack(item, quantity));
    }

    public static void dropItemAtEntity(Entity entity, ItemStack itemStack) {
        entity.getWorld().dropItem(entity.getLocation(), itemStack);
    }

    public static boolean isInColdBiome(Block block) {
        return block.getTemperature() <= 0.15 || coldBiomes.contains(block.getBiome()) || Utilities.isInHighMountain(block);
    }

    public static boolean isInHighMountain(Block block) {
        Biome biome = block.getBiome();
        return (biome == Biome.FROZEN_PEAKS || biome == Biome.JAGGED_PEAKS || biome == Biome.STONY_PEAKS || biome == Biome.MEADOW || biome == Biome.GROVE || biome == Biome.SNOWY_SLOPES) && block.getY() >= 95;
    }

    public static boolean isIce(Block block) {
        return Tag.ICE.isTagged((Keyed)block.getType()) || Utilities.is(block, Material.ICE) || Utilities.is(block, Material.PACKED_ICE) || Utilities.is(block, Material.FROSTED_ICE);
    }

    public static boolean isBelowMinimumLightLevel(Block block) {
        return block.getLightFromBlocks() <= Settings.meltAboveLightLevel;
    }

    public static <T> T cast(Block block) {
        return (T)block.getBlockData();
    }

    public static void increaseSnowLayersAt(Location location, int amount) {
        Block block = location.getBlock();
        if (Utilities.isSnowLayer(block)) {
            Snow snow = (Snow)Utilities.cast(block);
            int layers = snow.getLayers() + amount;
            snow.setLayers(Math.min(snow.getMaximumLayers(), layers));
            block.setBlockData((BlockData)snow);
            if (snow.getLayers() >= snow.getMaximumLayers()) {
                block.setType(Material.SNOW_BLOCK);
                int leftoverLayers = layers - snow.getMaximumLayers();
                Block upperBlock = Utilities.getRelativeBlock(block, BlockFace.UP);
                if (leftoverLayers > 0) {
                    upperBlock.setType(Material.SNOW);
                    Snow leftoverSnow = (Snow)Utilities.cast(upperBlock);
                    leftoverSnow.setLayers(Math.min(snow.getMaximumLayers(), leftoverLayers));
                    upperBlock.setBlockData((BlockData)leftoverSnow);
                }
            }
        }
    }

    public static void increaseSnowLayersFromPosing(Block block, Snow snow, int amount) {
        snow.setLayers(snow.getLayers() + amount);
        block.setBlockData((BlockData)snow);
        Bukkit.getPluginManager().callEvent((Event)new BlockFormEvent(block, block.getState()));
    }

    public static void decreaseSnowLayersFromMelting(Block block, Snow snow, int amount) {
        if (Utilities.canMoreLayersBeMelted(snow)) {
            int layers = snow.getLayers() - amount;
            if (layers == 0) {
                Logger.getAnonymousLogger().info("PLACING AIR");
                block.getWorld().setBlockData(block.getLocation(), Material.AIR.createBlockData());
            } else {
                snow.setLayers(layers);
                block.setBlockData((BlockData)snow);
                Bukkit.getPluginManager().callEvent((Event)new BlockFormEvent(block, block.getState()));
            }
        }
    }

    public static Block getPlayerGroundBlock(Player player) {
        return Utilities.getRelativeBlock(player.getLocation().getBlock(), BlockFace.DOWN);
    }

    public static Set<Chunk> getLoadedChunks() {
        int viewDistance = Math.min(Bukkit.getViewDistance(), 7);
        HashSet chunkSet = new HashSet();
        Bukkit.getOnlinePlayers().stream().filter(player -> Utilities.isValidWorld(player.getWorld())).map(player -> player.getLocation().getChunk()).filter(chunk -> !Utilities.isChunkExcluded(chunk)).forEach(chunk -> {
            int chunkX = chunk.getX();
            int chunkZ = chunk.getZ();
            for (int x = chunkX - viewDistance; x <= chunkX + viewDistance; ++x) {
                for (int z = chunkZ - viewDistance; z <= chunkZ + viewDistance; ++z) {
                    chunkSet.add(chunk.getWorld().getChunkAt(x, z));
                }
            }
        });
        return chunkSet.stream().filter(Chunk::isLoaded).collect(Collectors.toSet());
    }

    public static boolean isValidWorld(World world) {
        return Settings.snowPoseWorlds.contains(world.getName()) && world.getEnvironment() == World.Environment.NORMAL && world.hasStorm();
    }

    public static void runSnowPoseTaskForWorld(String world) {
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)BetterSnowierSnow.getInstance(), (Runnable)new SnowPoseTask(), (long)Settings.snowPoseFrequency, (long)Settings.snowPoseFrequency);
        Utilities.cancelSnowPoseTaskForWorld(world);
        Settings.snowPoseTasks.put(world, task);
    }

    public static void cancelSnowPoseTaskForWorld(String world) {
        BukkitTask task = Settings.snowPoseTasks.getOrDefault(world, null);
        if (task != null) {
            task.cancel();
            Bukkit.getScheduler().cancelTask(task.getTaskId());
        }
    }

    public static boolean shouldPoseSnow() {
        return (double)RANDOM.nextFloat() <= Settings.snowChancePercentage;
    }

    public static boolean shouldMeltSnow() {
        return (double)RANDOM.nextFloat() <= Settings.snowMeltPercentage;
    }

    public static boolean canMoreLayersBePlaced(Snow snow) {
        return snow.getLayers() < Settings.snowPoseMaxLayers;
    }

    public static boolean canMoreLayersBeMelted(Snow snow) {
        return snow.getLayers() > Settings.snowMeltMinLayers;
    }

    public static boolean isChunkExcludedForVanilla(Chunk chunk) {
        return Settings.excludedChunks.stream().filter(ExcludedChunk::preventVanilla).anyMatch(c -> c.isInExcludedChunk(chunk));
    }

    public static boolean isChunkExcluded(Chunk chunk) {
        return Settings.excludedChunks.stream().anyMatch(c -> c.isInExcludedChunk(chunk));
    }
}

