package io.github.macuguita.utils;

import io.github.macuguita.SpanishDelightRefabricated;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.FarmersDelight;

import java.util.function.Predicate;

public class ModFeatures {

    private static final class_5321<class_6796> WILD_GARLIC = modFeature("wild_garlic_placement");
    private static final class_5321<class_6796> WILD_RED_PEPPER = modFeature("wild_red_pepper_placement");
    private static final class_5321<class_6796> WILD_GREEN_PEPPER = modFeature("wild_green_pepper_placement");

    @NotNull
    private static class_5321<class_6796> modFeature(String name) {
        return class_5321.method_29179(class_7924.field_41245, class_2960.method_43902(SpanishDelightRefabricated.MOD_ID, name));
    }

    public static void init() {
        BiomeModifications.addFeature(new FDBiomeSelector(ModTags.Biomes.IS_PLAINS),
                class_2893.class_2895.field_13178, WILD_GARLIC);
        BiomeModifications.addFeature(new FDBiomeSelector(ModTags.Biomes.IS_SAVANNA),
                class_2893.class_2895.field_13178, WILD_RED_PEPPER);
        BiomeModifications.addFeature(new FDBiomeSelector(ModTags.Biomes.IS_TAIGA),
                class_2893.class_2895.field_13178, WILD_GREEN_PEPPER);
    }

    public record FDBiomeSelector(float minTemperature, float maxTemperature, class_6862<class_1959> allowed,
                                  @Nullable class_6862<class_1959> denied) implements Predicate<BiomeSelectionContext> {

        public FDBiomeSelector(class_6862<class_1959> tagKey) {
            this(-4f, 4f, tagKey, null);
        }

        @Override
        public boolean test(BiomeSelectionContext biomeSelectionContext) {
            class_6880<class_1959> biome = biomeSelectionContext.getBiomeRegistryEntry();
            float temp = biome.comp_349().method_8712();
            if (denied != null && biome.method_40220(denied)) return false;
            return biome.method_40220(allowed) && temp >= minTemperature && temp <= maxTemperature;
        }
    }
}