package io.github.macuguita.datagen;

import io.github.macuguita.item.ModItems;
import io.github.macuguita.utils.ModTags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.recipe.v1.ingredient.DefaultCustomIngredients;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2446;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import vectorwing.farmersdelight.common.crafting.CookingPotBookCategory;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

import java.util.concurrent.CompletableFuture;

public class ModRecipeProvider extends FabricRecipeProvider {

    public static final int FAST_COOKING = 100;      // 5 seconds
    public static final int NORMAL_COOKING = 200;    // 10 seconds
    public static final int SLOW_COOKING = 400;      // 20 seconds

    public static final float SMALL_EXP = 0.35F;
    public static final float MEDIUM_EXP = 1.0F;
    public static final float LARGE_EXP = 2.0F;

    public ModRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    protected class_2446 method_62766(class_7225.class_7874 wrapperLookup, class_8790 recipeExporter) {
        final class_7871<class_1792> itemLookup = wrapperLookup.method_46762(class_7924.field_41197);
        return new class_2446(wrapperLookup, recipeExporter) {
            @Override
            public void method_10419() {
                class_2450.method_62770(class_7923.field_41178, class_7800.field_40640, ModItems.GAZPACHO)
                        .method_10451(class_1856.method_8106(itemLookup.method_46735(CommonTags.CROPS_TOMATO)))
                        .method_10451(class_1856.method_8106(itemLookup.method_46735(ModTags.Items.GARLIC)))
                        .method_10451(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.WATER_BUCKETS)))
                        .method_10451(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.BREAD_FOODS)))
                        .method_10454(class_1802.field_8428)
                        .method_10442(method_32807(vectorwing.farmersdelight.common.registry.ModItems.TOMATO.get()), method_10426(vectorwing.farmersdelight.common.registry.ModItems.TOMATO.get()))
                        .method_10442(method_32807(ModItems.GARLIC), method_10426(ModItems.GARLIC))
                        .method_10431(recipeExporter);
                class_2450.method_62770(class_7923.field_41178, class_7800.field_40640, ModItems.PANTUMACA)
                        .method_10451(class_1856.method_8106(itemLookup.method_46735(CommonTags.CROPS_TOMATO)))
                        .method_10451(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.BREAD_FOODS)))
                        .method_10442(method_32807(vectorwing.farmersdelight.common.registry.ModItems.TOMATO.get()), method_10426(vectorwing.farmersdelight.common.registry.ModItems.TOMATO.get()))
                        .method_10442(method_32807(class_1802.field_8229), method_10426(class_1802.field_8229))
                        .method_10431(recipeExporter);

                class_2454.method_17802(class_1856.method_8091(ModItems.SQUID_RING), class_7800.field_40640, ModItems.FRIED_SQUID_RING, 0.35F, 200)
                        .method_10469(method_32807(ModItems.SQUID_RING), method_10426(ModItems.SQUID_RING))
                        .method_10431(recipeExporter);
                class_2454.method_35916(class_1856.method_8091(ModItems.SQUID_RING), class_7800.field_40640, ModItems.FRIED_SQUID_RING, 0.35F, 200 * 3)
                        .method_10469(method_32807(ModItems.SQUID_RING), method_10426(ModItems.SQUID_RING))
                        .method_36443(recipeExporter, ModItems.FRIED_SQUID_RING + "_from_campfire");
                class_2454.method_35918(class_1856.method_8091(ModItems.SQUID_RING), class_7800.field_40640, ModItems.FRIED_SQUID_RING, 0.35F, 200 / 2)
                        .method_10469(method_32807(ModItems.SQUID_RING), method_10426(ModItems.SQUID_RING))
                        .method_36443(recipeExporter, ModItems.FRIED_SQUID_RING + "_from_smoker");

                CookingPotRecipeBuilder.cookingPotRecipe(class_7923.field_41178, ModItems.BRAVA_POTATOES, 1, NORMAL_COOKING, MEDIUM_EXP, class_1802.field_8428)
                        .addIngredient(ModItems.SLICED_POTATO)
                        .addIngredient(ModItems.SLICED_POTATO)
                        .addIngredient(ModItems.PAPRIKA)
                        .unlockedByItems(method_32807(ModItems.SLICED_POTATO), ModItems.SLICED_POTATO)
                        .setRecipeBookCategory(CookingPotBookCategory.MEALS)
                        .build(recipeExporter);

                CookingPotRecipeBuilder.cookingPotRecipe(class_7923.field_41178, ModItems.CHURRO, 3, NORMAL_COOKING, MEDIUM_EXP)
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.WHEAT_CROPS)))
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.EGGS)))
                        .addIngredient(class_1802.field_8479)
                        .addIngredient(DefaultCustomIngredients.any(
                                class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.WATER_BUCKETS)),
                                class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.WATER_DRINKS)),
                                class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.WATERY_DRINKS)),
                                class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.MILK_BUCKETS)),
                                class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.MILK_DRINKS))
                        ))
                        .unlockedByItems(method_32807(class_1802.field_8861), class_1802.field_8861)
                        .unlockedByItems(method_32807(class_1802.field_8803), class_1802.field_8803, class_1802.field_56558, class_1802.field_56557)
                        .unlockedByItems(method_32807(class_1802.field_8479), class_1802.field_8479)
                        .unlockedByItems(method_32807(class_1802.field_8705), class_1802.field_8705)
                        .setRecipeBookCategory(CookingPotBookCategory.MISC)
                        .build(recipeExporter);

                CookingPotRecipeBuilder.cookingPotRecipe(class_7923.field_41178, ModItems.CROQUETTES, 1, NORMAL_COOKING, MEDIUM_EXP)
                        .addIngredient(vectorwing.farmersdelight.common.registry.ModItems.HAM.get())
                        .addIngredient(DefaultCustomIngredients.any(
                                class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.WATER_BUCKETS)),
                                class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.WATER_DRINKS)),
                                class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.WATERY_DRINKS)),
                                class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.MILK_BUCKETS)),
                                class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.MILK_DRINKS))
                        ))
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.WHEAT_CROPS)))
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.EGGS)))
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.BREAD_FOODS)))
                        .unlockedByItems(method_32807(class_1802.field_8705), class_1802.field_8705)
                        .unlockedByItems(method_32807(class_1802.field_8861), class_1802.field_8861)
                        .unlockedByItems(method_32807(class_1802.field_8803), class_1802.field_8803, class_1802.field_56558, class_1802.field_56557)
                        .unlockedByItems(method_32807(class_1802.field_8229), class_1802.field_8229)
                        .setRecipeBookCategory(CookingPotBookCategory.MISC)
                        .build(recipeExporter);

                CookingPotRecipeBuilder.cookingPotRecipe(class_7923.field_41178, ModItems.PAELLA, 1, SLOW_COOKING, LARGE_EXP, class_1802.field_8428)
                        .addIngredient(class_1802.field_8504)
                        .addIngredient(vectorwing.farmersdelight.common.registry.ModItems.CHICKEN_CUTS.get())
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(CommonTags.CROPS_RICE)))
                        .addIngredient(ModItems.PAPRIKA)
                        .addIngredient(ModItems.GREEN_BEAN)
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(ModTags.Items.GARLIC)))
                        .unlockedByItems(method_32807(class_1802.field_8504), class_1802.field_8504)
                        .unlockedByItems(method_32807(vectorwing.farmersdelight.common.registry.ModItems.CHICKEN_CUTS.get()), vectorwing.farmersdelight.common.registry.ModItems.CHICKEN_CUTS.get())
                        .unlockedByItems(method_32807(vectorwing.farmersdelight.common.registry.ModItems.RICE.get()), vectorwing.farmersdelight.common.registry.ModItems.RICE.get())
                        .unlockedByItems(method_32807(ModItems.PAPRIKA), ModItems.PAPRIKA)
                        .unlockedByItems(method_32807(ModItems.GREEN_BEAN), ModItems.GREEN_BEAN)
                        .unlockedByItems(method_32807(ModItems.GARLIC), ModItems.GARLIC)
                        .setRecipeBookCategory(CookingPotBookCategory.MEALS)
                        .build(recipeExporter);

                CookingPotRecipeBuilder.cookingPotRecipe(class_7923.field_41178, ModItems.PIL_PIL_COD, 1, SLOW_COOKING, LARGE_EXP, class_1802.field_8428)
                        .addIngredient(ModItems.GREEN_PEPPER)
                        .addIngredient(class_1802.field_8429)
                        .addIngredient(ModItems.SLICED_POTATO)
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(ModTags.Items.GARLIC)))
                        .unlockedByItems(method_32807(ModItems.GREEN_PEPPER), ModItems.GREEN_PEPPER)
                        .unlockedByItems(method_32807(class_1802.field_8429), class_1802.field_8429)
                        .unlockedByItems(method_32807(ModItems.SLICED_POTATO), ModItems.SLICED_POTATO)
                        .unlockedByItems(method_32807(ModItems.GARLIC), ModItems.GARLIC)
                        .setRecipeBookCategory(CookingPotBookCategory.MEALS)
                        .build(recipeExporter);

                CookingPotRecipeBuilder.cookingPotRecipe(class_7923.field_41178, ModItems.SPANISH_TORTILLA, 1, NORMAL_COOKING, LARGE_EXP)
                        .addIngredient(ModItems.SLICED_POTATO)
                        .addIngredient(ModItems.SLICED_ONION)
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.EGGS)))
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.EGGS)))
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.EGGS)))
                        .addIngredient(class_1856.method_8106(itemLookup.method_46735(ConventionalItemTags.EGGS)))
                        .unlockedByItems(method_32807(ModItems.SLICED_POTATO), ModItems.SLICED_POTATO)
                        .unlockedByItems(method_32807(ModItems.SLICED_ONION), ModItems.SLICED_ONION)
                        .unlockedByItems(method_32807(class_1802.field_8803), class_1802.field_8803, class_1802.field_56558, class_1802.field_56557)
                        .setRecipeBookCategory(CookingPotBookCategory.MEALS)
                        .build(recipeExporter);

                CuttingBoardRecipeBuilder.cuttingRecipe(class_1856.method_8091(vectorwing.farmersdelight.common.registry.ModItems.ONION.get()), class_1856.method_8106(itemLookup.method_46735(CommonTags.TOOLS_KNIFE)), ModItems.SLICED_ONION, 3)
                        .build(recipeExporter);
                CuttingBoardRecipeBuilder.cuttingRecipe(class_1856.method_8091(class_1802.field_8567), class_1856.method_8106(itemLookup.method_46735(CommonTags.TOOLS_KNIFE)), ModItems.SLICED_POTATO, 3)
                        .build(recipeExporter);
                CuttingBoardRecipeBuilder.cuttingRecipe(class_1856.method_8091(ModItems.RED_PEPPER), class_1856.method_8106(itemLookup.method_46735(CommonTags.TOOLS_KNIFE)), ModItems.PAPRIKA, 3)
                        .build(recipeExporter);
            }
        };
    }

    @Override
    public String method_10321() {
        return "Spanish Delight Refabricated";
    }
}
