/*
 * Decompiled with CFR 0.152.
 */
package net.flashlight.network;

import java.util.function.Supplier;
import net.flashlight.FlashlightMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FlashlightModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        FlashlightMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) {
        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this(new PlayerVariables());
            this.data.deserializeNBT(buffer.m_130260_());
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_(message.data().serializeNBT());
        }

        public static void handleData(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES).ifPresent(cap -> cap.deserializeNBT(message.data.serializeNBT()));
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        boolean _syncDirty = false;
        public double BatteryFlashlight = 100.0;
        public double BatteryLantern = 500.0;
        public boolean NightvisionVar = false;

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("BatteryFlashlight", this.BatteryFlashlight);
            nbt.m_128347_("BatteryLantern", this.BatteryLantern);
            nbt.m_128379_("NightvisionVar", this.NightvisionVar);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.BatteryFlashlight = nbt.m_128459_("BatteryFlashlight");
            this.BatteryLantern = nbt.m_128459_("BatteryLantern");
            this.NightvisionVar = nbt.m_128471_("NightvisionVar");
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("flashlight", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES ? this.instance.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.playerVariables.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.playerVariables.deserializeNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> FlashlightMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> FlashlightMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> FlashlightMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerTickUpdateSyncPlayerVariables(TickEvent.PlayerTickEvent event) {
            Player player;
            if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> {
                    if (capability._syncDirty) {
                        FlashlightMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability));
                        capability._syncDirty = false;
                    }
                });
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            event.getOriginal().getCapability(PLAYER_VARIABLES).ifPresent(original -> event.getEntity().getCapability(PLAYER_VARIABLES).ifPresent(clone -> {
                if (!event.isWasDeath()) {
                    clone.BatteryFlashlight = original.BatteryFlashlight;
                    clone.BatteryLantern = original.BatteryLantern;
                    clone.NightvisionVar = original.NightvisionVar;
                }
            }));
        }
    }
}

