/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrJoinMessages;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class ColorSystem {
    private static final List<String> legacyColors = Arrays.asList("&0", "&1", "&2", "&3", "&4", "&5", "&6", "&7", "&8", "&9", "&a", "&b", "&c", "&d", "&e", "\u00a70", "\u00a71", "\u00a72", "\u00a73", "\u00a74", "\u00a75", "\u00a76", "\u00a77", "\u00a78", "\u00a79", "\u00a7a", "\u00a7b", "\u00a7c", "\u00a7d", "\u00a7e");
    private static final List<String> specialChars = Arrays.asList("&l", "&n", "&o", "&k", "&m", "\u00a7l", "\u00a7n", "\u00a7o", "\u00a7k", "\u00a7m");
    private static final Pattern patternNormal = Pattern.compile("\\{#([0-9A-Fa-f]{6})\\}");
    private static final Pattern patternGrad = Pattern.compile("\\{#([0-9A-Fa-f]{6})>\\}(.*?)\\{#([0-9A-Fa-f]{6})<\\}");
    private static final Pattern patternOneFromTwo = Pattern.compile("\\{#([0-9A-Fa-f]{6})<>\\}");
    private static Matcher matcher;

    public static String sbcolorize(String input) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    public static String clear(String input) {
        input = ColorSystem.removePatterns(input);
        input = ColorSystem.removeLegacyColors(input);
        input = ColorSystem.removeSpecialChars(input);
        return input;
    }

    public static String removeSpecialChars(String input) {
        for (String chars : specialChars) {
            if (!input.contains(chars)) continue;
            input = input.replaceAll(chars, "");
        }
        return input;
    }

    public static String removeLegacyColors(String input) {
        for (String color : legacyColors) {
            if (!input.contains(color)) continue;
            input = input.replaceAll(color, "");
        }
        return input;
    }

    public static String removePatterns(String input) {
        input = input.replaceAll("\\{#([0-9A-Fa-f]{6})>\\}", "");
        input = input.replaceAll("\\{#([0-9A-Fa-f]{6})<\\}", "");
        input = input.replaceAll("\\{#([0-9A-Fa-f]{6})\\}", "");
        return input;
    }

    public static String colorize(String input) {
        input = ColorSystem.colorizeGradient(input);
        input = ColorSystem.colorizeRGB(input);
        return input;
    }

    public static String colorizeClassic(String input) {
        input = ChatColor.translateAlternateColorCodes((char)'&', (String)input);
        return input;
    }

    public static String colorizeGradient(String input) {
        matcher = patternOneFromTwo.matcher(input);
        StringBuffer output = new StringBuffer();
        while (matcher.find()) {
            String text = matcher.group(1);
            matcher.appendReplacement(output, "{#" + text + "<}{#" + text + ">}");
        }
        matcher.appendTail(output);
        input = output.toString();
        matcher = patternGrad.matcher(input);
        while (matcher.find()) {
            input = input.replace(matcher.group(), ColorSystem.color(matcher.group(2), new Color(Integer.parseInt(matcher.group(1), 16)), new Color(Integer.parseInt(matcher.group(3), 16))));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    public static String colorizeRGB(String input) {
        matcher = patternNormal.matcher(input);
        while (matcher.find()) {
            String color = matcher.group(1);
            if (color == null) {
                color = matcher.group(2);
            }
            input = input.replace(matcher.group(), "" + ColorSystem.getColor(color));
        }
        return input;
    }

    public static String color(String input, Color first, Color second) {
        ChatColor[] colors = ColorSystem.createGradient(first, second, ColorSystem.removeSpecialChars(input).length());
        return ColorSystem.apply(input, colors);
    }

    private static String apply(String input, ChatColor[] colors) {
        StringBuilder specialColors = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        String[] characters = input.split("");
        int outIndex = 0;
        for (int i = 0; i < characters.length; ++i) {
            if (!characters[i].equals("&") && !characters[i].equals("\u00a7")) {
                stringBuilder.append(colors[outIndex++]).append((CharSequence)specialColors).append(characters[i]);
                continue;
            }
            if (i + 1 >= characters.length) {
                stringBuilder.append(colors[outIndex++]).append((CharSequence)specialColors).append(characters[i]);
                continue;
            }
            if (characters[i + 1].equals("r")) {
                specialColors.setLength(0);
            } else {
                specialColors.append(characters[i]);
                specialColors.append(characters[i + 1]);
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    private static ChatColor[] createGradient(Color first, Color second, int amount) {
        ChatColor[] colors = new ChatColor[amount];
        int amountR = Math.abs(first.getRed() - second.getRed()) / (amount - 1);
        int amountG = Math.abs(first.getGreen() - second.getGreen()) / (amount - 1);
        int amountB = Math.abs(first.getBlue() - second.getBlue()) / (amount - 1);
        int[] colorDir = new int[]{first.getRed() < second.getRed() ? 1 : -1, first.getGreen() < second.getGreen() ? 1 : -1, first.getBlue() < second.getBlue() ? 1 : -1};
        for (int i = 0; i < amount; ++i) {
            Color color = new Color(first.getRed() + amountR * i * colorDir[0], first.getGreen() + amountG * i * colorDir[1], first.getBlue() + amountB * i * colorDir[2]);
            colors[i] = ChatColor.of((Color)color);
        }
        return colors;
    }

    public static ChatColor getColor(String matcher) {
        return ChatColor.of((Color)new Color(Integer.parseInt(matcher, 16)));
    }
}

