/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrJoinMessages;

import eu.mrneznamy.mrJoinMessages.ColorSystem;
import eu.mrneznamy.mrJoinMessages.MrJoinMessages;
import java.util.List;
import java.util.Random;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class JoinSystem
implements Listener {
    private final MrJoinMessages plugin;
    private boolean enabled;
    private boolean enabled1;
    private boolean enabled2;
    private boolean enabled3;
    private boolean placeholderAPIEnabled;

    public JoinSystem(MrJoinMessages plugin) {
        this.plugin = plugin;
        this.enabled = plugin.getConfig().getBoolean("Join-Leave.Enabled", true);
        this.enabled1 = plugin.getConfig().getBoolean("Welcome-Message.Enabled", true);
        this.enabled2 = plugin.getConfig().getBoolean("Welcome-Titles.Enabled", true);
        this.enabled3 = plugin.getConfig().getBoolean("Welcome-Sounds.Enabled", true);
        this.placeholderAPIEnabled = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        String joinMessage;
        Player player = event.getPlayer();
        String playerName = player.getName();
        if (this.enabled && (joinMessage = this.getJoinMessage(player)) != null) {
            event.setJoinMessage(joinMessage);
        }
        if (this.enabled3) {
            this.playWelcomeSound(player);
        }
        if (this.enabled1) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                List welcomeMessages = this.plugin.getConfig().getStringList("Welcome-Message.Lines");
                for (String message : welcomeMessages) {
                    message = this.processPlaceholders(player, message);
                    player.sendMessage(ColorSystem.colorize(message));
                }
            }, 20L);
        }
        if (this.enabled2) {
            String title = this.processPlaceholders(player, this.plugin.getConfig().getString("Welcome-Titles.Title"));
            String subtitle = this.processPlaceholders(player, this.plugin.getConfig().getString("Welcome-Titles.Subtitle"));
            player.sendTitle(ColorSystem.colorize(title), ColorSystem.colorize(subtitle));
        }
    }

    private void playWelcomeSound(Player player) {
        String soundName = null;
        switch (this.plugin.getConfig().getString("Welcome-Sounds.Type")) {
            case "NORMAL": {
                soundName = this.plugin.getConfig().getString("Welcome-Sounds.Normal-Sound");
                break;
            }
            case "RANDOM": {
                List randomSounds = this.plugin.getConfig().getStringList("Welcome-Sounds.Random-Sound");
                soundName = (String)randomSounds.get(new Random().nextInt(randomSounds.size()));
                break;
            }
            case "GROUP": {
                soundName = this.getGroupSound(player);
                break;
            }
        }
        if (soundName != null) {
            try {
                Sound sound = Sound.valueOf((String)soundName);
                float pitch = (float)this.plugin.getConfig().getDouble("Sound-Settings.PITCH", 1.0);
                float volume = (float)this.plugin.getConfig().getDouble("Sound-Settings.VOLUME", 1.0);
                player.playSound(player.getLocation(), sound, volume, pitch);
            }
            catch (IllegalArgumentException e) {
                player.sendMessage("Invalid sound name: " + soundName);
            }
        }
    }

    private String getGroupSound(Player player) {
        for (String group : this.plugin.getConfig().getConfigurationSection("Welcome-Sounds.Group-Sound").getKeys(false)) {
            String permission = this.plugin.getConfig().getString("Welcome-Sounds.Group-Sound." + group + ".Permission");
            if (!player.hasPermission(permission)) continue;
            return this.plugin.getConfig().getString("Welcome-Sounds.Group-Sound." + group + ".Sound");
        }
        return null;
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        String leaveMessage;
        Player player = event.getPlayer();
        if (this.enabled && (leaveMessage = this.getLeaveMessage(player)) != null) {
            event.setQuitMessage(leaveMessage);
        }
    }

    private String getJoinMessage(Player player) {
        String message = null;
        switch (this.plugin.getConfig().getString("Join-Leave.Type")) {
            case "NORMAL": {
                message = this.plugin.getConfig().getString("Join-Leave.Normal-Messages.Join");
                break;
            }
            case "RANDOM": {
                message = this.getRandomMessage(this.plugin.getConfig().getStringList("Join-Leave.Random-Messages.Join"));
                break;
            }
            case "GROUP": {
                message = this.getGroupJoinMessage(player);
            }
        }
        return this.processPlaceholders(player, message);
    }

    private String getLeaveMessage(Player player) {
        String message = null;
        switch (this.plugin.getConfig().getString("Join-Leave.Type")) {
            case "NORMAL": {
                message = this.plugin.getConfig().getString("Join-Leave.Normal-Messages.Leave");
                break;
            }
            case "RANDOM": {
                message = this.getRandomMessage(this.plugin.getConfig().getStringList("Join-Leave.Random-Messages.Leave"));
                break;
            }
            case "GROUP": {
                message = this.getGroupLeaveMessage(player);
            }
        }
        return this.processPlaceholders(player, message);
    }

    private String getRandomMessage(List<String> messages) {
        return messages.isEmpty() ? null : messages.get(new Random().nextInt(messages.size()));
    }

    private String getGroupJoinMessage(Player player) {
        for (String group : this.plugin.getConfig().getConfigurationSection("Join-Leave.Group-Messages").getKeys(false)) {
            String permission = this.plugin.getConfig().getString("Join-Leave.Group-Messages." + group + ".Permission");
            if (!player.hasPermission(permission)) continue;
            return this.plugin.getConfig().getString("Join-Leave.Group-Messages." + group + ".Join");
        }
        return null;
    }

    private String getGroupLeaveMessage(Player player) {
        for (String group : this.plugin.getConfig().getConfigurationSection("Join-Leave.Group-Messages").getKeys(false)) {
            String permission = this.plugin.getConfig().getString("Join-Leave.Group-Messages." + group + ".Permission");
            if (!player.hasPermission(permission)) continue;
            return this.plugin.getConfig().getString("Join-Leave.Group-Messages." + group + ".Leave");
        }
        return null;
    }

    private String processPlaceholders(Player player, String text) {
        if (text == null) {
            return null;
        }
        text = ColorSystem.colorize(text);
        text = text.replace("[PlayerName]", player.getName());
        if (this.placeholderAPIEnabled) {
            text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }
}

