/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrJoinMessages;

import eu.mrneznamy.mrJoinMessages.MrJoinMessages;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessagesConfig {
    private final File messagesFile;
    private final File configFile;
    private final YamlConfiguration messagesConfig;
    private final YamlConfiguration configConfig;

    public MessagesConfig() {
        MrJoinMessages plugin = MrJoinMessages.getInstance();
        this.messagesFile = new File(plugin.getDataFolder(), "new_messages.yml");
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!this.messagesFile.exists()) {
            plugin.saveResource("new_messages.yml", false);
        }
        if (!this.configFile.exists()) {
            plugin.saveResource("config.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.configConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void loadConfig() {
        try {
            this.messagesConfig.load(this.messagesFile);
            this.configConfig.load(this.configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void saveConfig() {
        try {
            this.messagesConfig.save(this.messagesFile);
            this.configConfig.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getString(String path) {
        return this.messagesConfig.getString(path);
    }

    public void addMissingSection() {
        if (!this.configConfig.contains("Sound-Settings")) {
            this.configConfig.createSection("Sound-Settings");
            this.configConfig.set("Sound-Settings.PITCH", (Object)1.0);
            this.configConfig.set("Sound-Settings.VOLUME", (Object)1.0);
            this.saveConfig();
        }
    }
}

