/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrJoinMessages;

import eu.mrneznamy.mrJoinMessages.ColorSystem;
import eu.mrneznamy.mrJoinMessages.JoinSystem;
import eu.mrneznamy.mrJoinMessages.MessagesConfig;
import eu.mrneznamy.mrJoinMessages.MrJoinMessagesCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MrJoinMessages
extends JavaPlugin {
    private static final String DOWNLOAD_URL = "https://fastdl.mrneznamy.eu/";
    private static final String PLUGIN_FILE_NAME = "MrJoinMessages-3.1.jar";
    private MessagesConfig messagesConfig;

    public void onEnable() {
        try {
            this.checkForUpdates();
            this.saveDefaultConfig();
            this.saveDefaultMessages();
            this.messagesConfig = new MessagesConfig();
            this.messagesConfig.loadConfig();
            this.messagesConfig.addMissingSection();
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("{#FB0000}"));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &a&l::::    ::::  ::::::::::: ::::    ::::"));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &a&l+:+:+: :+:+:+     :+:     +:+:+: :+:+:+ "));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &a&l+:+ +:+:+ +:+     +:+     +:+ +:+:+ +:+ "));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &a&l+#+  +:+  +#+     +#+     +#+  +:+  +#+ "));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &a&l+#+       +#+     +#+     +#+       +#+ "));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &a&l#+#       #+# #+# #+#     #+#       #+# "));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &a&l###       ###  #####      ###       ### "));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &a&l"));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &aPlugin has ben succesfully loaded!"));
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("{#FB0000}"));
            File dataFolder = this.getDataFolder();
            if (!dataFolder.exists()) {
                dataFolder.mkdir();
            }
            this.getServer().getPluginManager().registerEvents((Listener)new JoinSystem(this), (Plugin)this);
            this.getCommand("mjm").setExecutor((CommandExecutor)new MrJoinMessagesCommand(this));
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&cError during plugin initialization: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void onDisable() {
        Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &cPlugin has been disabled."));
    }

    private void saveDefaultMessages() {
        File messagesFile = new File(this.getDataFolder(), "new_messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("new_messages.yml", false);
        }
    }

    private void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                URL url = new URL(DOWNLOAD_URL);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    String version = this.getVersionFromFileName(PLUGIN_FILE_NAME);
                    if (response.toString().contains(version)) {
                        Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &aYou are running the latest version of the plugin."));
                    } else {
                        String newVersion = this.extractVersionFromResponse(response.toString());
                        Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&8[&aMrJoinMessages&8] &eNew version " + newVersion + " is available at https://fastdl.mrneznamy.eu/plugins/mrjoinmessages"));
                    }
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (IOException e) {
                Bukkit.getServer().getConsoleSender().sendMessage(ColorSystem.colorize("&cError checking for updates: " + e.getMessage()));
                e.printStackTrace();
            }
        });
    }

    private String extractVersionFromResponse(String response) {
        Pattern pattern = Pattern.compile("MrJoinMessages-(\\d+\\.\\d+).jar");
        Matcher matcher = pattern.matcher(response);
        return matcher.find() ? matcher.group(1) : "";
    }

    private String getVersionFromFileName(String fileName) {
        String versionWithExtension;
        int extensionIndex;
        String[] parts = fileName.split("-");
        if (parts.length >= 2 && (extensionIndex = (versionWithExtension = parts[1]).lastIndexOf(46)) != -1) {
            return versionWithExtension.substring(0, extensionIndex);
        }
        return "";
    }

    public MessagesConfig getMessagesConfig() {
        return this.messagesConfig;
    }

    public static MrJoinMessages getInstance() {
        return (MrJoinMessages)JavaPlugin.getPlugin(MrJoinMessages.class);
    }
}

