/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrJoinMessages;

import eu.mrneznamy.mrJoinMessages.ColorSystem;
import eu.mrneznamy.mrJoinMessages.MrJoinMessages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class MrJoinMessagesCommand
implements CommandExecutor,
TabCompleter {
    private final MrJoinMessages plugin;
    private boolean placeholderAPIEnabled;

    public MrJoinMessagesCommand(MrJoinMessages plugin) {
        this.plugin = plugin;
        this.placeholderAPIEnabled = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ColorSystem.colorize(this.plugin.getMessagesConfig().getString("MrJoinMessages.No-Player")));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("mjm.command.reload")) {
                sender.sendMessage(ColorSystem.colorize(this.plugin.getMessagesConfig().getString("MrJoinMessages.No-Permission")));
                return true;
            }
            this.plugin.getMessagesConfig().loadConfig();
            this.plugin.reloadConfig();
            sender.sendMessage(ColorSystem.colorize(this.plugin.getMessagesConfig().getString("MrJoinMessages.Reload")));
            return true;
        }
        if (args.length == 0 || args.length == 1 && args[0].equalsIgnoreCase("help")) {
            this.sendFirstPage(player);
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("help")) {
            this.sendFirstPage(player);
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("test")) {
            sender.sendMessage(ColorSystem.colorize(this.plugin.getMessagesConfig().getString("MrJoinMessages.Usage").replace("[Command]", "/mjm test").replace("[Arguments]", "(Join/Leave/Welcome/Title)")));
        } else if (args.length == 2 && args[0].equalsIgnoreCase("test") && args[1].equalsIgnoreCase("Join")) {
            if (!sender.hasPermission("mjm.command.test.Join")) {
                String message = this.plugin.getMessagesConfig().getString("MrJoinMessages.No-Permission");
                message = this.processPlaceholders(player, message);
                sender.sendMessage(ColorSystem.colorize(message));
                return true;
            }
            String title = this.getJoinMessage(player.getName());
            title = this.processPlaceholders(player, title);
            sender.sendMessage(ColorSystem.colorize(title));
        } else if (args.length == 2 && args[0].equalsIgnoreCase("test") && args[1].equalsIgnoreCase("Leave")) {
            if (!sender.hasPermission("mjm.command.test.Leave")) {
                String message = this.plugin.getMessagesConfig().getString("MrJoinMessages.No-Permission");
                message = this.processPlaceholders(player, message);
                sender.sendMessage(ColorSystem.colorize(message));
                return true;
            }
            String title = this.getLeaveMessage(player.getName());
            title = this.processPlaceholders(player, title);
            sender.sendMessage(ColorSystem.colorize(title));
        } else if (args.length == 2 && args[0].equalsIgnoreCase("test") && args[1].equalsIgnoreCase("Welcome")) {
            if (!sender.hasPermission("mjm.command.test.Welcome")) {
                String message = this.plugin.getMessagesConfig().getString("MrJoinMessages.No-Permission");
                message = this.processPlaceholders(player, message);
                sender.sendMessage(ColorSystem.colorize(message));
                return true;
            }
            List welcomeMessages = this.plugin.getConfig().getStringList("Welcome-Message.Lines");
            for (String message : welcomeMessages) {
                message = this.processPlaceholders(player, message);
                player.sendMessage(ColorSystem.colorize(message).replace("[PlayerName]", player.getName()));
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("test") && args[1].equalsIgnoreCase("Title")) {
            if (!sender.hasPermission("mjm.command.test.Title")) {
                String message = this.plugin.getMessagesConfig().getString("MrJoinMessages.No-Permission");
                message = this.processPlaceholders(player, message);
                sender.sendMessage(ColorSystem.colorize(message));
                return true;
            }
            String title = this.plugin.getConfig().getString("Welcome-Titles.Title").replace("[PlayerName]", player.getName());
            title = this.processPlaceholders(player, title);
            title = ColorSystem.colorize(title);
            String subtitle = this.plugin.getConfig().getString("Welcome-Titles.Subtitle").replace("[PlayerName]", player.getName());
            subtitle = this.processPlaceholders(player, subtitle);
            subtitle = ColorSystem.colorize(subtitle);
            player.sendTitle(title, subtitle);
        } else if (args.length == 2 && args[0].equalsIgnoreCase("test") && args[1].equalsIgnoreCase("Sound")) {
            if (!sender.hasPermission("mjm.command.test.Sound")) {
                sender.sendMessage(ColorSystem.colorize(this.plugin.getMessagesConfig().getString("MrJoinMessages.No-Permission")));
                return true;
            }
            this.playWelcomeSound(player);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("reload");
            completions.add("test");
        } else if (args.length == 2 && args[0].equalsIgnoreCase("test")) {
            completions.add("Join");
            completions.add("Leave");
            completions.add("Welcome");
            completions.add("Title");
            completions.add("Sound");
        }
        return completions;
    }

    private void playWelcomeSound(Player player) {
        String soundName = null;
        switch (this.plugin.getConfig().getString("Welcome-Sounds.Type")) {
            case "NORMAL": {
                soundName = this.plugin.getConfig().getString("Welcome-Sounds.Normal-Sound");
                break;
            }
            case "RANDOM": {
                List randomSounds = this.plugin.getConfig().getStringList("Welcome-Sounds.Random-Sound");
                soundName = (String)randomSounds.get(new Random().nextInt(randomSounds.size()));
                break;
            }
            case "GROUP": {
                soundName = this.getGroupSound(player);
                break;
            }
        }
        if (soundName != null) {
            try {
                Sound sound = Sound.valueOf((String)soundName);
                float pitch = (float)this.plugin.getConfig().getDouble("Sound-Settings.PITCH", 1.0);
                float volume = (float)this.plugin.getConfig().getDouble("Sound-Settings.VOLUME", 1.0);
                player.playSound(player.getLocation(), sound, volume, pitch);
            }
            catch (IllegalArgumentException e) {
                player.sendMessage("Invalid sound name: " + soundName);
            }
        }
    }

    private String getGroupSound(Player player) {
        String group;
        String permission;
        Iterator var2 = this.plugin.getConfig().getConfigurationSection("Welcome-Sounds.Group-Sound").getKeys(false).iterator();
        do {
            if (!var2.hasNext()) {
                return null;
            }
            group = (String)var2.next();
        } while (!player.hasPermission(permission = this.plugin.getConfig().getString("Welcome-Sounds.Group-Sound." + group + ".Permission")));
        return this.plugin.getConfig().getString("Welcome-Sounds.Group-Sound." + group + ".Sound");
    }

    private void sendFirstPage(Player player) {
        player.sendMessage(ColorSystem.colorize("&a"));
        player.sendMessage(ColorSystem.colorize("{#FB0000>}&lMrJoinMessages 2.8{#FD6767<} &a1/&c1"));
        player.sendMessage(ColorSystem.colorize("&7This version is redistributed."));
        player.sendMessage(ColorSystem.colorize("&a"));
        player.sendMessage(ColorSystem.colorize(" &8&l\u27a3 &a/mjm test (Join/Leave/Welcome/Title) &8- &7Send test message."));
        player.sendMessage(ColorSystem.colorize(" &8&l\u27a3 &a/mjm reload &8- &7Reload plugin configuration."));
        player.sendMessage(ColorSystem.colorize(""));
    }

    private String getJoinMessage(String playerName) {
        switch (this.plugin.getConfig().getString("Join-Leave.Type")) {
            case "NORMAL": {
                return ColorSystem.colorize(this.plugin.getConfig().getString("Join-Leave.Normal-Messages.Join").replace("[PlayerName]", playerName));
            }
            case "RANDOM": {
                return this.getRandomJoinMessage(playerName);
            }
            case "GROUP": {
                return this.getGroupJoinMessage(playerName);
            }
        }
        return null;
    }

    private String getLeaveMessage(String playerName) {
        switch (this.plugin.getConfig().getString("Join-Leave.Type")) {
            case "NORMAL": {
                return ColorSystem.colorize(this.plugin.getConfig().getString("Join-Leave.Normal-Messages.Leave").replace("[PlayerName]", playerName));
            }
            case "RANDOM": {
                return this.getRandomLeaveMessage(playerName);
            }
            case "GROUP": {
                return this.getGroupLeaveMessage(playerName);
            }
        }
        return null;
    }

    private String getRandomJoinMessage(String playerName) {
        return ColorSystem.colorize(this.getRandomMessage(this.plugin.getConfig().getStringList("Join-Leave.Random-Messages.Join"), playerName));
    }

    private String getRandomLeaveMessage(String playerName) {
        return ColorSystem.colorize(this.getRandomMessage(this.plugin.getConfig().getStringList("Join-Leave.Random-Messages.Leave"), playerName));
    }

    private String getRandomMessage(List<String> messages, String playerName) {
        if (messages != null && !messages.isEmpty()) {
            int randomIndex = (int)(Math.random() * (double)messages.size());
            return messages.get(randomIndex).replace("[PlayerName]", playerName);
        }
        return null;
    }

    private String getGroupJoinMessage(String playerName) {
        String group;
        String permission;
        Iterator var2 = this.plugin.getConfig().getConfigurationSection("Join-Leave.Group-Messages").getKeys(false).iterator();
        do {
            if (!var2.hasNext()) {
                return null;
            }
            group = (String)var2.next();
            permission = this.plugin.getConfig().getString("Join-Leave.Group-Messages." + group + ".Permission");
        } while (!this.plugin.getServer().getPlayer(playerName).hasPermission(permission));
        return ColorSystem.colorize(this.plugin.getConfig().getString("Join-Leave.Group-Messages." + group + ".Join").replace("[PlayerName]", playerName));
    }

    private String getGroupLeaveMessage(String playerName) {
        String group;
        String permission;
        Iterator var2 = this.plugin.getConfig().getConfigurationSection("Join-Leave.Group-Messages").getKeys(false).iterator();
        do {
            if (!var2.hasNext()) {
                return null;
            }
            group = (String)var2.next();
            permission = this.plugin.getConfig().getString("Join-Leave.Group-Messages." + group + ".Permission");
        } while (!this.plugin.getServer().getPlayer(playerName).hasPermission(permission));
        return ColorSystem.colorize(this.plugin.getConfig().getString("Join-Leave.Group-Messages." + group + ".Leave").replace("[PlayerName]", playerName));
    }

    private String processPlaceholders(Player player, String text) {
        if (text == null) {
            return null;
        }
        text = ColorSystem.colorize(text);
        text = text.replace("[PlayerName]", player.getName());
        if (this.placeholderAPIEnabled) {
            text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }
}

