/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.util;

import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.util.CommonUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayerUtils {
    public static boolean isPlayerMoving() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return player.m_20184_().m_165925_() > 0.01;
    }

    public static boolean isPlayerInAir() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return !player.m_20096_();
    }

    public static boolean isPlayerOnGround() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return player.m_20096_();
    }

    public static float getHealthPercentage() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return 0.0f;
        }
        return player.m_21223_() / player.m_21233_();
    }

    public static int getFoodLevel() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return 0;
        }
        return player.m_36324_().m_38702_();
    }

    public static int getExperienceLevel() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return 0;
        }
        return player.f_36078_;
    }

    public static boolean hasTargetedEntityIsMob() {
        Mob mob;
        Entity entity = PlayerUtils.getTargetedEntity();
        if (entity == null) {
            return false;
        }
        return entity instanceof Enemy || entity instanceof Mob && (mob = (Mob)entity).m_5448_() instanceof Player;
    }

    public static Entity getTargetedEntity() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult hit = mc.f_91077_;
        if (hit instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            return entityHit.m_82443_();
        }
        return null;
    }

    public static BlockState getTargetedBlock() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult hit = mc.f_91077_;
        if (hit instanceof BlockHitResult) {
            BlockHitResult targetedBlock = (BlockHitResult)hit;
            return Minecraft.m_91087_().f_91074_.m_9236_().m_8055_(targetedBlock.m_82425_());
        }
        return null;
    }

    public static String getTargetedEntityType() {
        Entity entity = PlayerUtils.getTargetedEntity();
        return entity != null ? CommonUtils.toPathString(entity.m_6095_().toString()) : null;
    }

    public static String getTargetedBlockId() {
        BlockState blockState = PlayerUtils.getTargetedBlock();
        return blockState != null ? CommonUtils.toPathString(blockState.m_60734_().m_7705_()) : null;
    }

    public static String getVehicleType() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_20202_() == null) {
            return null;
        }
        return CommonUtils.toPathString(player.m_20202_().m_6095_().toString());
    }

    public static String getMainHandItemId() {
        try {
            ItemStack stack = Minecraft.m_91087_().f_91074_.m_21205_();
            Item item = stack.m_41720_();
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
            if (id == null) {
                SmartKeyPrompts.LOGGER.warn("[SKP] \u4e3b\u624b\u7269\u54c1\u6ce8\u518c\u540d\u5f02\u5e38\uff1a{}", (Object)item.toString());
                return "unknown:unknown";
            }
            return id.toString();
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("[SKP] \u83b7\u53d6\u4e3b\u624b\u7269\u54c1ID\u5931\u8d25", (Throwable)e);
            return "unknown:unknown";
        }
    }
}

