/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.data;

import com.mafuyu404.oelib.forge.data.DataManager;
import com.mafuyu404.oelib.forge.data.DataRegistry;
import com.mafuyu404.oelib.forge.data.mvel.ExpressionEngine;
import com.mafuyu404.oelib.forge.data.mvel.FunctionUsageAnalyzer;
import com.mafuyu404.oelib.forge.event.DataReloadEvent;
import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.data.DataPackFunctions;
import com.mafuyu404.smartkeyprompts.data.KeyPromptData;
import com.mafuyu404.smartkeyprompts.data.KeyPromptDataExtractor;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="smartkeyprompts", value={Dist.CLIENT})
public class KeyPromptEngine {
    private static final KeyPromptDataExtractor dataExtractor = new KeyPromptDataExtractor();
    private static DataManager<KeyPromptData> dataManager;
    private static boolean initialized;
    private static boolean dataLoaded;

    public static void initialize() {
        if (!initialized) {
            dataManager = DataManager.register(KeyPromptData.class);
            DataRegistry.register(KeyPromptData.class);
            DataRegistry.registerExtractor(KeyPromptData.class, (FunctionUsageAnalyzer.DataExpressionExtractor)dataExtractor);
            initialized = true;
            SmartKeyPrompts.LOGGER.info("KeyPromptEngine initialized with OELib");
        }
    }

    @SubscribeEvent
    public static void onDataReload(DataReloadEvent event) {
        if (event.getDataClass() == KeyPromptData.class) {
            SmartKeyPrompts.LOGGER.info("KeyPrompt data reloaded: {} entries loaded, {} invalid", (Object)event.getLoadedCount(), (Object)event.getInvalidCount());
            dataLoaded = true;
            KeyPromptEngine.checkAndInitializeExpressionEngine();
        }
    }

    private static void checkAndInitializeExpressionEngine() {
        if (dataLoaded && !DataRegistry.isExpressionEngineInitialized()) {
            SmartKeyPrompts.LOGGER.info("Triggering smart function registration...");
            DataRegistry.initializeExpressionEngine();
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!initialized) {
            KeyPromptEngine.initialize();
        }
        if (!DataRegistry.isExpressionEngineInitialized()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91080_ != null || dataManager == null) {
            return;
        }
        DataPackFunctions.setCurrentPlayer((Player)player);
        Map loadedData = dataManager.getAllData();
        for (Map.Entry entry : loadedData.entrySet()) {
            KeyPromptData data = (KeyPromptData)entry.getValue();
            if (!ExpressionEngine.checkModLoadedCondition(data.vars())) continue;
            KeyPromptEngine.processKeyPromptData(data, (Player)player);
        }
    }

    private static void processKeyPromptData(KeyPromptData data, Player player) {
        Map context = ExpressionEngine.createContext(data.vars());
        for (KeyPromptData.Entry entry : data.entries()) {
            if (!ExpressionEngine.checkConditions(entry.when(), (Map)context)) continue;
            ExpressionEngine.executeActions(entry.then(), (Map)context);
        }
    }

    public static DataManager<KeyPromptData> getDataManager() {
        if (!initialized) {
            KeyPromptEngine.initialize();
        }
        return dataManager;
    }

    public static void forceReload() {
        if (dataManager != null) {
            dataLoaded = false;
            DataRegistry.resetExpressionEngine();
            Minecraft.m_91087_().m_91391_();
        }
    }

    static {
        initialized = false;
        dataLoaded = false;
    }
}

