/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.data;

import com.mafuyu404.oelib.api.data.ExpressionFunction;
import com.mafuyu404.smartkeyprompts.util.CommonUtils;
import com.mafuyu404.smartkeyprompts.util.DataComponentUtils;
import com.mafuyu404.smartkeyprompts.util.KeyUtils;
import com.mafuyu404.smartkeyprompts.util.NBTUtils;
import com.mafuyu404.smartkeyprompts.util.PlayerUtils;
import com.mafuyu404.smartkeyprompts.util.PromptUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DataPackFunctions {
    private static Player currentPlayer;

    @ExpressionFunction(description="\u83b7\u53d6\u5f53\u524d\u73a9\u5bb6", category="mod")
    public static Player player() {
        return currentPlayer;
    }

    @ExpressionFunction(description="\u83b7\u53d6\u4e3b\u624b\u7269\u54c1ID", category="mod")
    public static String mainHandItem() {
        return PlayerUtils.getMainHandItemId();
    }

    @ExpressionFunction(description="\u83b7\u53d6\u8f7d\u5177\u7c7b\u578b", category="mod")
    public static String vehicleType() {
        return PlayerUtils.getVehicleType();
    }

    @ExpressionFunction(description="\u83b7\u53d6\u76ee\u6807\u5b9e\u4f53\u7c7b\u578b", category="mod")
    public static String targetedEntity() {
        return PlayerUtils.getTargetedEntityType();
    }

    @ExpressionFunction(description="\u68c0\u67e5\u73a9\u5bb6\u662f\u5426\u5728\u8f7d\u5177\u4e2d", category="mod")
    public static boolean isInVehicle() {
        return currentPlayer != null && currentPlayer.getVehicle() != null;
    }

    @ExpressionFunction(description="\u68c0\u67e5\u73a9\u5bb6\u662f\u5426\u5728\u6e38\u6cf3", category="mod")
    public static boolean isSwimming() {
        return currentPlayer != null && currentPlayer.isSwimming();
    }

    @ExpressionFunction(description="\u68c0\u67e5\u73a9\u5bb6\u662f\u5426\u5728\u98de\u884c", category="mod")
    public static boolean isFlying() {
        return currentPlayer != null && DataPackFunctions.currentPlayer.getAbilities().flying;
    }

    @ExpressionFunction(description="\u83b7\u53d6\u73a9\u5bb6\u751f\u547d\u503c\u767e\u5206\u6bd4", category="mod")
    public static float healthPercentage() {
        return PlayerUtils.getHealthPercentage();
    }

    @ExpressionFunction(description="\u83b7\u53d6\u73a9\u5bb6\u9965\u997f\u503c", category="mod")
    public static int foodLevel() {
        return PlayerUtils.getFoodLevel();
    }

    @ExpressionFunction(description="\u83b7\u53d6\u73a9\u5bb6\u7ecf\u9a8c\u7b49\u7ea7", category="mod")
    public static int experienceLevel() {
        return PlayerUtils.getExperienceLevel();
    }

    @ExpressionFunction(description="\u6839\u636e\u63cf\u8ff0\u83b7\u53d6\u6309\u952e\u540d\u79f0", category="mod")
    public static String getKeyByDesc(String desc) {
        return KeyUtils.getKeyByDesc(desc);
    }

    @ExpressionFunction(description="\u68c0\u67e5\u6307\u5b9a\u6309\u952e\u662f\u5426\u88ab\u6309\u4e0b", category="mod")
    public static boolean isKeyPressedOfDesc(String key) {
        return KeyUtils.isKeyPressedOfDesc(key);
    }

    @ExpressionFunction(description="\u68c0\u67e5\u76ee\u6807\u5b9e\u4f53\u662f\u5426\u4e3a\u6307\u5b9a\u7c7b\u578b", category="mod")
    public static boolean isTargetedEntityType(String entityType) {
        String targetType = PlayerUtils.getTargetedEntityType();
        return targetType != null && targetType.equals(entityType);
    }

    @ExpressionFunction(description="\u662f\u5426\u5b58\u5728\u76ee\u6807\u5b9e\u4f53", category="mod")
    public static boolean hasTargetEntity() {
        return PlayerUtils.getTargetedEntity() != null;
    }

    @ExpressionFunction(description="\u68c0\u67e5\u6444\u50cf\u673a\u5b9e\u4f53\u662f\u5426\u4e3a\u73a9\u5bb6", category="mod")
    public static boolean isCameraPlayer() {
        return Minecraft.getInstance().getCameraEntity() instanceof Player;
    }

    @ExpressionFunction(description="\u68c0\u67e5\u6e38\u620f\u754c\u9762\u662f\u5426\u6253\u5f00", category="mod")
    public static boolean isScreenOpen() {
        return CommonUtils.isScreenOpen();
    }

    @ExpressionFunction(description="\u68c0\u67e5\u73a9\u5bb6\u662f\u5426\u5728\u521b\u9020\u6a21\u5f0f", category="mod")
    public static boolean isCreativeMode() {
        return currentPlayer != null && DataPackFunctions.currentPlayer.getAbilities().instabuild;
    }

    @ExpressionFunction(description="\u68c0\u67e5\u73a9\u5bb6\u662f\u5426\u62e5\u6709\u6307\u5b9a\u7269\u54c1", category="mod")
    public static boolean hasItem(String itemId) {
        if (currentPlayer == null) {
            return false;
        }
        return DataPackFunctions.currentPlayer.getInventory().items.stream().anyMatch(stack -> CommonUtils.toPathString(stack.getItem().getDescriptionId()).equals(itemId));
    }

    @ExpressionFunction(description="\u68c0\u67e5\u4e3b\u624b\u7269\u54c1\u662f\u5426\u5305\u542b\u6307\u5b9a\u6570\u636e\u7ec4\u4ef6")
    public static boolean hasMainHandComponent(String componentId) {
        ItemStack itemStack = DataComponentUtils.getMainHandItem(currentPlayer);
        return DataComponentUtils.hasComponent(itemStack, componentId);
    }

    @ExpressionFunction(description="\u68c0\u67e5\u4e3b\u624b\u7269\u54c1\u6570\u636e\u7ec4\u4ef6\u7684\u503c\u662f\u5426\u5339\u914d")
    public static boolean checkMainHandComponent(String componentId, String expectedValue) {
        ItemStack itemStack = DataComponentUtils.getMainHandItem(currentPlayer);
        return DataComponentUtils.checkComponentValue(itemStack, componentId, expectedValue);
    }

    @ExpressionFunction(description="\u83b7\u53d6\u4e3b\u624b\u7269\u54c1\u6570\u636e\u7ec4\u4ef6\u7684\u503c")
    public static String getMainHandComponentValue(String componentId) {
        ItemStack itemStack = DataComponentUtils.getMainHandItem(currentPlayer);
        return DataComponentUtils.getComponentValue(itemStack, componentId);
    }

    @ExpressionFunction(description="\u68c0\u67e5\u4e3b\u624b\u7269\u54c1\u81ea\u5b9a\u4e49\u6570\u636e\u662f\u5426\u5305\u542b\u6307\u5b9a\u952e")
    public static boolean hasMainHandCustomDataKey(String key) {
        ItemStack itemStack = DataComponentUtils.getMainHandItem(currentPlayer);
        return DataComponentUtils.hasCustomDataKey(itemStack, key);
    }

    @ExpressionFunction(description="\u83b7\u53d6\u4e3b\u624b\u7269\u54c1\u7684\u5b8c\u6574\u6570\u636e\u7ec4\u4ef6\u4fe1\u606f")
    public static String getMainHandComponents() {
        ItemStack itemStack = DataComponentUtils.getMainHandItem(currentPlayer);
        return DataComponentUtils.getComponentsAsString(itemStack);
    }

    @ExpressionFunction(description="\u83b7\u53d6\u4e3b\u624b\u7269\u54c1\u7684\u81ea\u5b9a\u4e49\u6570\u636e\u5b57\u7b26\u4e32")
    public static String getMainHandCustomDataString() {
        ItemStack itemStack = DataComponentUtils.getMainHandItem(currentPlayer);
        return DataComponentUtils.getCustomDataAsString(itemStack);
    }

    @ExpressionFunction(description="\u68c0\u67e5\u76ee\u6807\u5b9e\u4f53\u662f\u5426\u5305\u542b\u6307\u5b9aNBT\u8def\u5f84", category="mod")
    public static boolean hasTargetEntityNBT(String nbtPath) {
        CompoundTag nbt = NBTUtils.getTargetEntityNBT();
        return NBTUtils.checkNBTPath(nbt, nbtPath);
    }

    @ExpressionFunction(description="\u68c0\u67e5\u76ee\u6807\u5b9e\u4f53NBT\u8def\u5f84\u7684\u503c\u662f\u5426\u5339\u914d", category="mod")
    public static boolean checkTargetEntityNBT(String nbtPath, String expectedValue) {
        CompoundTag nbt = NBTUtils.getTargetEntityNBT();
        return NBTUtils.checkNBTValue(nbt, nbtPath, expectedValue);
    }

    @ExpressionFunction(description="\u83b7\u53d6\u76ee\u6807\u5b9e\u4f53NBT\u8def\u5f84\u7684\u503c", category="mod")
    public static String getTargetEntityNBTValue(String nbtPath) {
        CompoundTag nbt = NBTUtils.getTargetEntityNBT();
        return NBTUtils.getNBTValue(nbt, nbtPath);
    }

    @ExpressionFunction(description="\u83b7\u53d6\u76ee\u6807\u5b9e\u4f53\u7684\u5b8c\u6574SNBT", category="mod")
    public static String getTargetEntitySNBT() {
        CompoundTag nbt = NBTUtils.getTargetEntityNBT();
        return NBTUtils.getNBTAsString(nbt);
    }

    @ExpressionFunction(description="\u68c0\u67e5\u76ee\u6807\u65b9\u5757\u5b9e\u4f53\u662f\u5426\u5305\u542b\u6307\u5b9aNBT\u8def\u5f84", category="mod")
    public static boolean hasTargetBlockEntityNBT(String nbtPath) {
        CompoundTag nbt = NBTUtils.getTargetBlockEntityNBT();
        return NBTUtils.checkNBTPath(nbt, nbtPath);
    }

    @ExpressionFunction(description="\u68c0\u67e5\u76ee\u6807\u65b9\u5757\u5b9e\u4f53NBT\u8def\u5f84\u7684\u503c\u662f\u5426\u5339\u914d", category="mod")
    public static boolean checkTargetBlockEntityNBT(String nbtPath, String expectedValue) {
        CompoundTag nbt = NBTUtils.getTargetBlockEntityNBT();
        return NBTUtils.checkNBTValue(nbt, nbtPath, expectedValue);
    }

    @ExpressionFunction(description="\u83b7\u53d6\u76ee\u6807\u5b9e\u4f53NBT\u8def\u5f84\u7684\u503c", category="mod")
    public static String getTargetBlockEntityNBTValue(String nbtPath) {
        CompoundTag nbt = NBTUtils.getTargetBlockEntityNBT();
        return NBTUtils.getNBTValue(nbt, nbtPath);
    }

    @ExpressionFunction(description="\u83b7\u53d6\u76ee\u6807\u5b9e\u4f53\u7684\u5b8c\u6574SNBT", category="mod")
    public static String getTargetBlockEntitySNBT() {
        CompoundTag nbt = NBTUtils.getTargetBlockEntityNBT();
        return NBTUtils.getNBTAsString(nbt);
    }

    @ExpressionFunction(description="\u83b7\u53d6\u5f53\u524d\u65f6\u95f4\u6233", category="mod")
    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @ExpressionFunction(description="\u663e\u793a\u6309\u952e\u63d0\u793a", category="mod")
    public static void show(String modid, String desc) {
        PromptUtils.show(modid, desc);
    }

    @ExpressionFunction(description="\u663e\u793a\u81ea\u5b9a\u4e49\u6309\u952e\u63d0\u793a", category="mod")
    public static void custom(String modid, String key, String desc) {
        PromptUtils.custom(modid, key, desc);
    }

    @ExpressionFunction(description="\u663e\u793a\u6309\u952e\u522b\u540d\u63d0\u793a", category="mod")
    public static void alias(String modid, String key, String desc) {
        PromptUtils.alias(modid, key, desc);
    }

    public static void setCurrentPlayer(Player currentPlayer) {
        DataPackFunctions.currentPlayer = currentPlayer;
    }
}

