/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.init;

import com.mafuyu404.smartkeyprompts.Config;
import com.mafuyu404.smartkeyprompts.init.HUD;
import com.mafuyu404.smartkeyprompts.init.KeyPrompt;
import com.mafuyu404.smartkeyprompts.init.ModKeybindings;
import com.mafuyu404.smartkeyprompts.util.KeyUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;

@EventBusSubscriber(modid="smartkeyprompts", value={Dist.CLIENT})
public class ConfigAction {
    @SubscribeEvent
    public static void mouseAction(InputEvent.MouseButton.Pre event) {
        if (event.getAction() != 1) {
            return;
        }
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (!KeyUtils.isKeyPressed(ModKeybindings.CONTROL_KEY.getKey().getValue())) {
            return;
        }
        if (event.getButton() == 0) {
            List<String> currentKey = ConfigAction.getCurrentKeyDescs();
            ConfigAction.modifyKey(currentKey);
        }
        if (event.getButton() == 1) {
            int position = (Integer)Config.POSITION.get();
            if (position == 8) {
                Config.POSITION.set((Object)1);
            } else {
                Config.POSITION.set((Object)(position + 1));
            }
            Config.POSITION.save();
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void wheelAction(InputEvent.MouseScrollingEvent event) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (!KeyUtils.isKeyPressed(ModKeybindings.CONTROL_KEY.getKey().getValue())) {
            return;
        }
        ConfigAction.scaleHUD(event.getScrollDeltaY());
        event.setCanceled(true);
    }

    public static void scaleHUD(double delta) {
        double scale = (Double)Config.SCALE.get();
        scale = delta < 0.0 ? Math.max(scale - 0.1, 0.0) : Math.min(scale + 0.1, 10.0);
        Config.SCALE.set((Object)scale);
        Config.SCALE.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getCurrentKeyDescs() {
        ArrayList<String> currentKey = new ArrayList<String>();
        List<KeyPrompt> list = HUD.KeyPromptList;
        synchronized (list) {
            for (KeyPrompt keyPrompt : HUD.KeyPromptList) {
                if (keyPrompt == null || keyPrompt.isCustom || KeyUtils.getKeyByDesc(keyPrompt.desc) == null) continue;
                currentKey.add(keyPrompt.desc);
            }
        }
        return currentKey;
    }

    public static void modifyKey(List<String> keyNames) {
        if (HUD.KeyMappingCache != null) {
            return;
        }
        if (keyNames == null || keyNames.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        HUD.KeyMappingCache = minecraft.options.keyMappings;
        KeyMapping[] allKeys = minecraft.options.keyMappings;
        HashSet<String> targetKeys = new HashSet<String>();
        for (String keyName : keyNames) {
            if (keyName == null) continue;
            targetKeys.add(keyName.toLowerCase());
        }
        ArrayList<KeyMapping> filteredKeysList = new ArrayList<KeyMapping>();
        for (KeyMapping key : allKeys) {
            if (key == null || !targetKeys.contains(key.getName().toLowerCase())) continue;
            filteredKeysList.add(key);
        }
        minecraft.options.keyMappings = filteredKeysList.toArray(new KeyMapping[0]);
        minecraft.setScreen((Screen)new KeyBindsScreen(null, minecraft.options));
    }
}

