/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.init;

import com.mafuyu404.smartkeyprompts.init.KeyDrawer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class KeyRenderer {
    private static Font cachedFont;

    private static Font getFont() {
        if (cachedFont == null) {
            cachedFont = Minecraft.getInstance().font;
        }
        return cachedFont;
    }

    public static void drawKeyBoardKey(GuiGraphics guiGraphics, int x, int y, String key, boolean pressed) {
        Font font = KeyRenderer.getFont();
        int width = font.width(key);
        int height = 12;
        PoseStack poseStack = guiGraphics.pose();
        KeyDrawer.drawUnpressedKey(poseStack, x, y, 6, 16, 0, 0, 6, 16, pressed);
        KeyDrawer.drawUnpressedKey(poseStack, x + 6, y, width - 1, 16, 6, 0, 20, 16, pressed);
        KeyDrawer.drawUnpressedKey(poseStack, x + 6 + width - 1, y, 6, 16, 26, 0, 6, 16, pressed);
        guiGraphics.drawCenteredString(font, key, x + width / 2 + 6, y + (height - 8) / 2 + 1, -1);
    }

    public static void drawText(GuiGraphics guiGraphics, int x, int y, String text) {
        Font font = KeyRenderer.getFont();
        guiGraphics.drawString(font, text, x, y, -1, true);
    }
}

