/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.init;

import com.mafuyu404.smartkeyprompts.util.KeyUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="smartkeyprompts", value={Dist.CLIENT})
public class KeyStateManager {
    private static final Map<String, Boolean> keyStateCache = new ConcurrentHashMap<String, Boolean>();
    private static final Set<String> activeKeys = ConcurrentHashMap.newKeySet();
    private static final Map<String, Boolean> previousStates = new ConcurrentHashMap<String, Boolean>();
    private static int cleanupCounter = 0;
    private static final int CLEANUP_INTERVAL = 100;

    public static void registerKeys(Set<String> keyDescs) {
        activeKeys.addAll(keyDescs);
        for (String desc : keyDescs) {
            String key = KeyUtils.getKeyByDesc(desc);
            if (key == null || key.isEmpty()) continue;
            activeKeys.add(key);
        }
    }

    public static boolean isKeyPressed(String keyDesc) {
        return keyStateCache.getOrDefault(keyDesc, false);
    }

    public static void clearUnusedCache() {
        keyStateCache.keySet().retainAll(activeKeys);
        previousStates.keySet().retainAll(activeKeys);
    }

    public static void clearAllCache() {
        keyStateCache.clear();
        previousStates.clear();
        activeKeys.clear();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        KeyStateManager.updateKeyStates();
        if (++cleanupCounter >= 100) {
            KeyStateManager.clearUnusedCache();
            cleanupCounter = 0;
        }
    }

    private static void updateKeyStates() {
        for (String keyDesc : activeKeys) {
            boolean currentState = KeyStateManager.checkKeyState(keyDesc);
            Boolean previousState = previousStates.get(keyDesc);
            if (previousState != null && previousState == currentState) continue;
            keyStateCache.put(keyDesc, currentState);
            previousStates.put(keyDesc, currentState);
        }
    }

    private static boolean checkKeyState(String keyDesc) {
        for (KeyMapping keyMapping : Minecraft.getInstance().options.keyMappings) {
            if (!keyDesc.equals(keyMapping.getName())) continue;
            return keyMapping.isDown();
        }
        return false;
    }
}

