/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.util;

import com.mafuyu404.smartkeyprompts.init.KeyPrompt;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.lwjgl.glfw.GLFW;

public class KeyUtils {
    private static final Collection<String> DisabledKeyMappingList = new HashSet<String>();
    private static final HashMap<String, Integer> KEY_MAP = new HashMap();
    public static InputConstants.Key unknownKey;

    public static ArrayList<KeyPrompt> getAllKeyBindings() {
        Minecraft mc = Minecraft.getInstance();
        ArrayList<KeyPrompt> bindingList = new ArrayList<KeyPrompt>();
        for (KeyMapping binding : mc.options.keyMappings) {
            KeyPrompt info = new KeyPrompt("", binding.getKey().getName(), binding.getName(), false);
            bindingList.add(info);
        }
        return bindingList;
    }

    public static String translateKey(String key) {
        if (key.contains("+")) {
            StringBuilder result = new StringBuilder();
            List.of(key.split("\\+")).forEach(part -> {
                if (!result.isEmpty()) {
                    result.append("+");
                }
                result.append(KeyUtils.translateKey(part));
            });
            return result.toString();
        }
        Object text = Component.translatable((String)key).getString();
        if (((String)text).contains("key.keyboard")) {
            text = ((String)text).split("\\.")[2].toUpperCase();
        }
        if (((String)text).contains("key.mouse")) {
            text = Component.translatable((String)"key.mouse.button").getString() + ((String)text).split("\\.")[2].toUpperCase();
        }
        return text;
    }

    public static boolean isKeyPressed(int glfwKeyCode) {
        Minecraft minecraft = Minecraft.getInstance();
        long windowHandle = minecraft.getWindow().getWindow();
        if (windowHandle == 0L) {
            return false;
        }
        try {
            return GLFW.glfwGetKey((long)windowHandle, (int)glfwKeyCode) == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isKeyPressedOfDesc(String key) {
        for (KeyMapping keyMapping : Minecraft.getInstance().options.keyMappings) {
            if (!key.equals(keyMapping.getName()) || !keyMapping.isDown()) continue;
            return true;
        }
        return false;
    }

    public static String getKeyByDesc(String desc) {
        for (KeyPrompt keyPrompt : KeyUtils.getAllKeyBindings()) {
            if (!keyPrompt.desc.equals(desc)) continue;
            return keyPrompt.key;
        }
        return "key.keyboard.unknown";
    }

    public static boolean isRightClickKey(String keyDesc) {
        String keyName = KeyUtils.getKeyByDesc(keyDesc);
        return keyName.equals("key.mouse.right") || keyName.equals("key.use");
    }

    public static boolean isPhysicalKeyPressed(String keyName) {
        if (keyName == null || keyName.isEmpty()) {
            return false;
        }
        if (keyName.contains("+")) {
            String[] keys;
            for (String key : keys = keyName.split("\\+")) {
                if (KeyUtils.isPhysicalKeyPressed(key.trim())) continue;
                return false;
            }
            return true;
        }
        return KeyUtils.isPhysicalKeySinglePressed(keyName);
    }

    public static boolean isPhysicalKeySinglePressed(String keyName) {
        if (keyName == null || keyName.isEmpty()) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        long windowHandle = minecraft.getWindow().getWindow();
        if (windowHandle == 0L) {
            return false;
        }
        try {
            Integer glfwKey = KEY_MAP.get(keyName);
            if (glfwKey == null) {
                return false;
            }
            if (keyName.startsWith("key.mouse.")) {
                return GLFW.glfwGetMouseButton((long)windowHandle, (int)glfwKey) == 1;
            }
            if (keyName.startsWith("key.keyboard.")) {
                return GLFW.glfwGetKey((long)windowHandle, (int)glfwKey) == 1;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isKeyDisabled(String desc) {
        return DisabledKeyMappingList.contains(desc);
    }

    public static Collection<String> getDisabledKeyMappingList() {
        return DisabledKeyMappingList;
    }

    public static void disableKeyMapping(String desc) {
        DisabledKeyMappingList.add(desc);
    }

    public static void disableKeyMapping(List<String> list) {
        DisabledKeyMappingList.addAll(list);
    }

    public static void disableAllKeyMapping() {
        KeyUtils.getAllKeyBindings().forEach(keyPrompt -> KeyUtils.disableKeyMapping(keyPrompt.desc));
    }

    public static void enableKeyMapping(String desc) {
        DisabledKeyMappingList.remove(desc);
    }

    public static void enableKeyMapping(List<String> list) {
        list.forEach(KeyUtils::enableKeyMapping);
    }

    public static void enableAllKeyMapping() {
        DisabledKeyMappingList.clear();
    }

    public static void addKeyMap(String key, int code) {
        KEY_MAP.put(key, code);
    }

    public static int getGLFWKey(String key) {
        return KEY_MAP.getOrDefault(key, -1);
    }

    public static String getKeyDisplayName(String keyDesc) {
        String keyName = KeyUtils.getKeyByDesc(keyDesc);
        return KeyUtils.translateKey(keyName);
    }

    public static String getKeysDisplayName(String ... keyDescs) {
        if (keyDescs == null || keyDescs.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < keyDescs.length; ++i) {
            if (i > 0) {
                result.append("+");
            }
            result.append(KeyUtils.getKeyDisplayName(keyDescs[i]));
        }
        return result.toString();
    }
}

