/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.util;

import com.mafuyu404.smartkeyprompts.util.PlayerUtils;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class NBTUtils {
    private static final Map<String, NbtPathArgument.NbtPath> pathCache = new ConcurrentHashMap<String, NbtPathArgument.NbtPath>();
    private static final Map<String, CompoundTag> snbtCache = new ConcurrentHashMap<String, CompoundTag>();
    private static final int MAX_CACHE_SIZE = 200;

    private static NbtPathArgument.NbtPath getCachedPath(String nbtPath) {
        return pathCache.computeIfAbsent(nbtPath, path -> {
            try {
                if (pathCache.size() > 200) {
                    pathCache.clear();
                }
                return NbtPathArgument.nbtPath().parse(new StringReader(path));
            }
            catch (CommandSyntaxException e) {
                return null;
            }
        });
    }

    private static CompoundTag getCachedSNBT(String snbt) {
        return snbtCache.computeIfAbsent(snbt, s -> {
            try {
                if (snbtCache.size() > 200) {
                    snbtCache.clear();
                }
                return TagParser.parseTag((String)s);
            }
            catch (CommandSyntaxException e) {
                return null;
            }
        });
    }

    public static boolean checkNBTPath(CompoundTag nbt, String nbtPath) {
        if (nbt == null || nbtPath == null || nbtPath.trim().isEmpty()) {
            return false;
        }
        try {
            NbtPathArgument.NbtPath path = NBTUtils.getCachedPath(nbtPath);
            if (path == null) {
                return false;
            }
            return !path.get((Tag)nbt).isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkNBTValue(CompoundTag nbt, String nbtPath, String expectedValue) {
        if (nbt == null || nbtPath == null || expectedValue == null) {
            return false;
        }
        if (nbtPath.trim().isEmpty()) {
            return false;
        }
        try {
            NbtPathArgument.NbtPath path = NBTUtils.getCachedPath(nbtPath);
            if (path == null) {
                return false;
            }
            List results = path.get((Tag)nbt);
            for (Tag tag : results) {
                if (!expectedValue.equals(tag.getAsString())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getNBTValue(CompoundTag nbt, String nbtPath) {
        if (nbt == null || nbtPath == null || nbtPath.trim().isEmpty()) {
            return null;
        }
        try {
            NbtPathArgument.NbtPath path = NBTUtils.getCachedPath(nbtPath);
            if (path == null) {
                return null;
            }
            List results = path.get((Tag)nbt);
            if (!results.isEmpty()) {
                return ((Tag)results.get(0)).getAsString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean matchSNBT(CompoundTag nbt, String snbt) {
        if (nbt == null || snbt == null || snbt.trim().isEmpty()) {
            return false;
        }
        try {
            CompoundTag expectedNbt = NBTUtils.getCachedSNBT(snbt);
            if (expectedNbt == null) {
                return false;
            }
            return nbt.equals((Object)expectedNbt);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static CompoundTag getTargetEntityNBT() {
        try {
            Entity entity = PlayerUtils.getTargetedEntity();
            if (entity == null) {
                return null;
            }
            CompoundTag nbt = new CompoundTag();
            entity.saveWithoutId(nbt);
            return nbt;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CompoundTag getTargetBlockEntityNBT() {
        try {
            Minecraft mc = Minecraft.getInstance();
            HitResult hitResult = mc.hitResult;
            if (!(hitResult instanceof BlockHitResult)) {
                return null;
            }
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            BlockPos pos = blockHit.getBlockPos();
            BlockEntity blockEntity = mc.level.getBlockEntity(pos);
            if (blockEntity == null) {
                return null;
            }
            return blockEntity.saveWithoutMetadata((HolderLookup.Provider)mc.level.registryAccess());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getNBTAsString(CompoundTag nbt) {
        try {
            return nbt != null ? nbt.toString() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void clearCache() {
        pathCache.clear();
        snbtCache.clear();
    }
}

