/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.util;

import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.util.CommonUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class PlayerUtils {
    public static boolean isPlayerMoving() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        return player.getDeltaMovement().horizontalDistanceSqr() > 0.01;
    }

    public static boolean isPlayerInAir() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        return !player.onGround();
    }

    public static boolean isPlayerOnGround() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        return player.onGround();
    }

    public static float getHealthPercentage() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0.0f;
        }
        return player.getHealth() / player.getMaxHealth();
    }

    public static int getFoodLevel() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0;
        }
        return player.getFoodData().getFoodLevel();
    }

    public static int getExperienceLevel() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0;
        }
        return player.experienceLevel;
    }

    public static boolean hasTargetedEntityIsMob() {
        Mob mob;
        Entity entity = PlayerUtils.getTargetedEntity();
        if (entity == null) {
            return false;
        }
        return entity instanceof Enemy || entity instanceof Mob && (mob = (Mob)entity).getTarget() instanceof Player;
    }

    public static Entity getTargetedEntity() {
        Minecraft mc = Minecraft.getInstance();
        HitResult hit = mc.hitResult;
        if (hit instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            return entityHit.getEntity();
        }
        return null;
    }

    public static BlockState getTargetedBlock() {
        Minecraft mc = Minecraft.getInstance();
        HitResult hit = mc.hitResult;
        if (hit instanceof BlockHitResult) {
            BlockHitResult targetedBlock = (BlockHitResult)hit;
            return Minecraft.getInstance().player.level().getBlockState(targetedBlock.getBlockPos());
        }
        return null;
    }

    public static String getTargetedEntityType() {
        Entity entity = PlayerUtils.getTargetedEntity();
        return entity != null ? CommonUtils.toPathString(entity.getType().toString()) : null;
    }

    public static String getTargetedBlockId() {
        BlockState blockState = PlayerUtils.getTargetedBlock();
        return blockState != null ? CommonUtils.toPathString(blockState.getBlock().getDescriptionId()) : null;
    }

    public static String getVehicleType() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.getVehicle() == null) {
            return null;
        }
        return CommonUtils.toPathString(player.getVehicle().getType().toString());
    }

    public static String getMainHandItemId() {
        try {
            ItemStack stack = Minecraft.getInstance().player.getMainHandItem();
            Item item = stack.getItem();
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            return id.toString();
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("[SKP] \u83b7\u53d6\u4e3b\u624b\u7269\u54c1ID\u5931\u8d25", (Throwable)e);
            return "unknown:unknown";
        }
    }
}

