/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.init;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class KeyDrawer {
    private static final ResourceLocation TEXTURE_UNPRESSED = ResourceLocation.fromNamespaceAndPath((String)"smartkeyprompts", (String)"textures/gui/unpressed_key.png");
    private static final ResourceLocation TEXTURE_PRESSED = ResourceLocation.fromNamespaceAndPath((String)"smartkeyprompts", (String)"textures/gui/pressed_key.png");
    public static final int TEXTURE_WIDTH = 32;
    public static final int TEXTURE_HEIGHT = 16;

    public static void drawUnpressedKey(PoseStack poseStack, int x, int y, int width, int height, int texX, int texY, int texWidth, int texHeight, boolean pressed) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        if (pressed) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_PRESSED);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_UNPRESSED);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 0.0f);
        float u0 = (float)texX / 32.0f;
        float v0 = (float)texY / 16.0f;
        float u1 = (float)(texX + texWidth) / 32.0f;
        float v1 = (float)(texY + texHeight) / 16.0f;
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix = poseStack.last().pose();
        buffer.addVertex(matrix, 0.0f, (float)height, 0.0f).setUv(u0, v1);
        buffer.addVertex(matrix, (float)width, (float)height, 0.0f).setUv(u1, v1);
        buffer.addVertex(matrix, (float)width, 0.0f, 0.0f).setUv(u1, v0);
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setUv(u0, v0);
        BufferUploader.drawWithShader((MeshData)Objects.requireNonNull(buffer.build()));
        poseStack.popPose();
        RenderSystem.disableBlend();
    }
}

