/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.init;

import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.init.KeyPrompt;
import com.mafuyu404.smartkeyprompts.util.CommonUtils;
import com.mafuyu404.smartkeyprompts.util.KeyUtils;
import com.mafuyu404.smartkeyprompts.util.PlayerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.lwjgl.glfw.GLFW;

@Deprecated
public class Utils {
    public static String getVehicleType() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.getVehicle() == null) {
            return null;
        }
        return CommonUtils.toPathString(player.getVehicle().getType().toString());
    }

    public static String getMainHandItemId() {
        try {
            ItemStack stack = Minecraft.getInstance().player.getMainHandItem();
            Item item = stack.getItem();
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            return id.toString();
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("[SKP] \u83b7\u53d6\u4e3b\u624b\u7269\u54c1ID\u5931\u8d25", (Throwable)e);
            return "unknown:unknown";
        }
    }

    public static String toPathString(String key) {
        String[] path = key.split("\\.");
        return path[1] + ":" + path[2];
    }

    public static Entity getTargetedEntity() {
        Minecraft mc = Minecraft.getInstance();
        HitResult hit = mc.hitResult;
        if (hit instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            return entityHit.getEntity();
        }
        return null;
    }

    public static BlockState getTargetedBlock() {
        Minecraft mc = Minecraft.getInstance();
        HitResult hit = mc.hitResult;
        if (hit instanceof BlockHitResult) {
            BlockHitResult targetedBlock = (BlockHitResult)hit;
            return Minecraft.getInstance().player.level().getBlockState(targetedBlock.getBlockPos());
        }
        return null;
    }

    public static String getTargetedEntityType() {
        Entity entity = PlayerUtils.getTargetedEntity();
        return entity != null ? CommonUtils.toPathString(entity.getType().toString()) : null;
    }

    public static String getTargetedBlockId() {
        BlockState blockState = PlayerUtils.getTargetedBlock();
        return blockState != null ? CommonUtils.toPathString(blockState.getBlock().getDescriptionId()) : null;
    }

    public static ArrayList<KeyPrompt> getAllKeyBindings() {
        Minecraft mc = Minecraft.getInstance();
        ArrayList<KeyPrompt> bindingList = new ArrayList<KeyPrompt>();
        for (KeyMapping binding : mc.options.keyMappings) {
            KeyPrompt info = new KeyPrompt("", binding.getKey().getName(), binding.getName(), false);
            bindingList.add(info);
        }
        return bindingList;
    }

    public static String translateKey(String key) {
        if (key.contains("+")) {
            StringBuilder result = new StringBuilder();
            List.of(key.split("\\+")).forEach(part -> {
                if (!result.isEmpty()) {
                    result.append("+");
                }
                result.append(KeyUtils.translateKey(part));
            });
            return result.toString();
        }
        Object text = Component.translatable((String)key).getString();
        if (((String)text).contains("key.keyboard")) {
            text = ((String)text).split("\\.")[2].toUpperCase();
        }
        if (((String)text).contains("key.mouse")) {
            text = Component.translatable((String)"key.mouse.button").getString() + ((String)text).split("\\.")[2].toUpperCase();
        }
        return text;
    }

    public static boolean isKeyPressed(int glfwKeyCode) {
        Minecraft minecraft = Minecraft.getInstance();
        long windowHandle = minecraft.getWindow().getWindow();
        if (windowHandle == 0L) {
            return false;
        }
        try {
            return GLFW.glfwGetKey((long)windowHandle, (int)glfwKeyCode) == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isKeyPressedOfDesc(String key) {
        for (KeyMapping keyMapping : Minecraft.getInstance().options.keyMappings) {
            if (!key.equals(keyMapping.getName()) || !keyMapping.isDown()) continue;
            return true;
        }
        return false;
    }

    public static String getKeyByDesc(String desc) {
        for (KeyPrompt keyPrompt : KeyUtils.getAllKeyBindings()) {
            if (!keyPrompt.desc.equals(desc)) continue;
            return keyPrompt.key;
        }
        return "key.keyboard.unknown";
    }

    public static boolean isScreenOpen() {
        return Minecraft.getInstance().screen != null;
    }

    public static boolean isPlayerMoving() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        return player.getDeltaMovement().horizontalDistanceSqr() > 0.01;
    }

    public static boolean isPlayerInAir() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        return !player.onGround();
    }

    public static boolean isPlayerOnGround() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        return player.onGround();
    }

    public static float getHealthPercentage() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0.0f;
        }
        return player.getHealth() / player.getMaxHealth();
    }

    public static int getFoodLevel() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0;
        }
        return player.getFoodData().getFoodLevel();
    }

    public static int getExperienceLevel() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0;
        }
        return player.experienceLevel;
    }

    public static boolean hasTargetedEntityIsMob() {
        Mob mob;
        Entity entity = PlayerUtils.getTargetedEntity();
        if (entity == null) {
            return false;
        }
        return entity instanceof Enemy || entity instanceof Mob && (mob = (Mob)entity).getTarget() instanceof Player;
    }

    public static String getKeyDisplayName(String keyDesc) {
        String keyName = KeyUtils.getKeyByDesc(keyDesc);
        return KeyUtils.translateKey(keyName);
    }

    public static String getKeysDisplayName(String ... keyDescs) {
        if (keyDescs == null || keyDescs.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < keyDescs.length; ++i) {
            if (i > 0) {
                result.append("+");
            }
            result.append(KeyUtils.getKeyDisplayName(keyDescs[i]));
        }
        return result.toString();
    }

    public static boolean isRightClickKey(String keyDesc) {
        String keyName = KeyUtils.getKeyByDesc(keyDesc);
        return keyName.equals("key.mouse.right") || keyName.equals("key.use");
    }

    public static boolean isPhysicalKeyPressed(String keyName) {
        if (keyName == null || keyName.isEmpty()) {
            return false;
        }
        if (keyName.contains("+")) {
            String[] keys;
            for (String key : keys = keyName.split("\\+")) {
                if (KeyUtils.isPhysicalKeyPressed(key.trim())) continue;
                return false;
            }
            return true;
        }
        return KeyUtils.isPhysicalKeySinglePressed(keyName);
    }

    private static boolean isPhysicalKeySinglePressed(String keyName) {
        if (keyName == null || keyName.isEmpty()) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        long windowHandle = minecraft.getWindow().getWindow();
        if (windowHandle == 0L) {
            return false;
        }
        try {
            int glfwKey = KeyUtils.getGLFWKey(keyName);
            if (keyName.startsWith("key.mouse.")) {
                return GLFW.glfwGetMouseButton((long)windowHandle, (int)glfwKey) == 1;
            }
            if (keyName.startsWith("key.keyboard.")) {
                return GLFW.glfwGetKey((long)windowHandle, (int)glfwKey) == 1;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

