/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class DataComponentUtils {
    private static final Map<String, DataComponentType<?>> componentTypeCache = new ConcurrentHashMap();
    private static final int MAX_CACHE_SIZE = 200;

    private static <T> DataComponentType<T> getCachedComponentType(String componentId) {
        return componentTypeCache.computeIfAbsent(componentId, id -> {
            try {
                ResourceLocation resourceLocation;
                if (componentTypeCache.size() > 200) {
                    componentTypeCache.clear();
                }
                if ((resourceLocation = ResourceLocation.tryParse((String)id)) == null) {
                    resourceLocation = ResourceLocation.withDefaultNamespace((String)id);
                }
                return (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(resourceLocation);
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    public static boolean hasComponent(ItemStack itemStack, String componentId) {
        if (itemStack == null || itemStack.isEmpty() || componentId == null || componentId.trim().isEmpty()) {
            return false;
        }
        try {
            DataComponentType componentType = DataComponentUtils.getCachedComponentType(componentId);
            if (componentType == null) {
                return false;
            }
            return itemStack.has(componentType);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkComponentValue(ItemStack itemStack, String componentId, String expectedValue) {
        if (itemStack == null || itemStack.isEmpty() || componentId == null || expectedValue == null) {
            return false;
        }
        if (componentId.trim().isEmpty()) {
            return false;
        }
        try {
            DataComponentType componentType = DataComponentUtils.getCachedComponentType(componentId);
            if (componentType == null) {
                return false;
            }
            Object value = itemStack.get(componentType);
            if (value == null) {
                return false;
            }
            return expectedValue.equals(value.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getComponentValue(ItemStack itemStack, String componentId) {
        if (itemStack == null || itemStack.isEmpty() || componentId == null || componentId.trim().isEmpty()) {
            return null;
        }
        try {
            DataComponentType componentType = DataComponentUtils.getCachedComponentType(componentId);
            if (componentType == null) {
                return null;
            }
            Object value = itemStack.get(componentType);
            return value != null ? value.toString() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean hasCustomDataKey(ItemStack itemStack, String key) {
        if (itemStack == null || itemStack.isEmpty() || key == null || key.trim().isEmpty()) {
            return false;
        }
        try {
            CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            return customData.contains(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ItemStack getMainHandItem(Player player) {
        if (player == null) {
            return ItemStack.EMPTY;
        }
        try {
            return player.getMainHandItem();
        }
        catch (Exception e) {
            return ItemStack.EMPTY;
        }
    }

    public static String getComponentsAsString(ItemStack itemStack) {
        try {
            if (itemStack == null || itemStack.isEmpty()) {
                return null;
            }
            return itemStack.getComponents().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCustomDataAsString(ItemStack itemStack) {
        try {
            if (itemStack == null || itemStack.isEmpty()) {
                return null;
            }
            CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            return customData.isEmpty() ? null : customData.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void clearCache() {
        componentTypeCache.clear();
    }
}

