/*
 * Decompiled with CFR 0.152.
 */
package me.katto.subtitlemod.Client;

import java.awt.Color;
import java.util.Objects;
import me.katto.subtitlemod.Client.ClientConfig;
import me.katto.subtitlemod.Utils.MessageUtils;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class SubtitleRender {
    public static String currentMessage = "";
    public static long endTime = 0L;

    public static void renderSubtitle(GuiGraphics guiGraphics) {
        if (!currentMessage.isEmpty() && System.nanoTime() < endTime) {
            Minecraft mc = Minecraft.getInstance();
            int screenWidth = mc.getWindow().getGuiScaledWidth();
            int screenHeight = mc.getWindow().getGuiScaledHeight();
            ClientConfig config = (ClientConfig)AutoConfig.getConfigHolder(ClientConfig.class).getConfig();
            int innerPadding = config.innerPadding;
            int outerPadding = config.outerPadding;
            float textScale = config.textScale;
            double separationBelow = config.separationBelow;
            double separationRight = config.separationRight;
            int cornerCut = config.cornerCut;
            boolean textCentered = config.textCentered;
            int color = new Color(config.backgroundColor.backgroundRed, config.backgroundColor.backgroundGreen, config.backgroundColor.backgroundBlue, config.backgroundColor.backgroundAlpha).getRGB();
            String[] lines = currentMessage.split(";");
            Objects.requireNonNull(mc.font);
            int lineHeight = (int)(9.0f * textScale);
            int maxWidth = 0;
            for (String line : lines) {
                int lineWidth = (int)((float)mc.font.width(MessageUtils.unColor(line)) * textScale);
                if (lineWidth <= maxWidth) continue;
                maxWidth = lineWidth;
            }
            int totalWidth = (int)((double)(maxWidth + innerPadding) + (double)innerPadding * separationRight);
            int totalHeight = (int)((double)(lines.length * lineHeight + innerPadding) + (double)innerPadding * separationBelow);
            int startX = screenWidth / 2 - totalWidth / 2;
            int startY = screenHeight - totalHeight - outerPadding;
            int endX = startX + totalWidth;
            int endY = startY + totalHeight;
            guiGraphics.fill(startX + cornerCut, startY, endX - cornerCut, startY + cornerCut, color);
            guiGraphics.fill(startX + cornerCut, endY - cornerCut, endX - cornerCut, endY, color);
            guiGraphics.fill(startX, startY + cornerCut, startX + cornerCut, endY - cornerCut, color);
            guiGraphics.fill(endX - cornerCut, startY + cornerCut, endX, endY - cornerCut, color);
            guiGraphics.fill(startX + cornerCut, startY + cornerCut, endX - cornerCut, endY - cornerCut, color);
            for (int i = 0; i < lines.length; ++i) {
                int textX;
                String line = MessageUtils.color(lines[i]);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(textScale, textScale, 1.0f);
                if (textCentered) {
                    int lineWidth = mc.font.width(MessageUtils.unColor(line));
                    textX = (int)(((float)startX + ((float)totalWidth - (float)lineWidth * textScale) / 2.0f) / textScale);
                } else {
                    textX = (int)((float)(startX + innerPadding) / textScale);
                }
                int textY = (int)((float)(startY + innerPadding + i * lineHeight) / textScale);
                guiGraphics.drawString(mc.font, line, textX, textY, 0xFFFFFF);
                guiGraphics.pose().popPose();
            }
        }
    }
}

