/*
 * Decompiled with CFR 0.152.
 */
package me.katto.subtitlemod;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.concurrent.TimeUnit;
import me.katto.subtitlemod.Client.SubtitleRender;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SubtitlePacket(int seconds, String message) {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"subtitlemod", (String)"network");
    public static final StreamCodec<FriendlyByteBuf, SubtitlePacket> STREAM_CODEC = StreamCodec.ofMember(SubtitlePacket::encode, SubtitlePacket::decode);

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(SubtitlePacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.seconds);
        buf.writeUtf(msg.message);
    }

    public static SubtitlePacket decode(FriendlyByteBuf buf) {
        int seconds = buf.readInt();
        String message = buf.readUtf();
        return new SubtitlePacket(seconds, message);
    }

    public static void handle(PacketContext<SubtitlePacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            SubtitleRender.endTime = System.nanoTime() + TimeUnit.SECONDS.toNanos(((SubtitlePacket)ctx.message()).seconds);
            SubtitleRender.currentMessage = ((SubtitlePacket)ctx.message()).message;
        }
    }
}

