/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creepersdeco.block;

import net.mcreator.creepersdeco.init.CreepersDecoModBlocks;
import net.mcreator.creepersdeco.procedures.LampBooleanDarkOakProcedure;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class DarkOakLampBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public DarkOakLampBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)DarkOakLampBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{DarkOakLampBlock.box((double)15.0, (double)2.0, (double)15.0, (double)16.0, (double)7.0, (double)16.0), DarkOakLampBlock.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0), DarkOakLampBlock.box((double)7.5, (double)13.0, (double)1.0, (double)8.5, (double)14.0, (double)15.0), DarkOakLampBlock.box((double)1.0, (double)13.0, (double)7.5, (double)15.0, (double)14.0, (double)8.5), DarkOakLampBlock.box((double)15.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), DarkOakLampBlock.box((double)0.0, (double)7.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), DarkOakLampBlock.box((double)1.0, (double)7.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0), DarkOakLampBlock.box((double)1.0, (double)7.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)DarkOakLampBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{DarkOakLampBlock.box((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)7.0, (double)1.0), DarkOakLampBlock.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0), DarkOakLampBlock.box((double)7.5, (double)13.0, (double)1.0, (double)8.5, (double)14.0, (double)15.0), DarkOakLampBlock.box((double)1.0, (double)13.0, (double)7.5, (double)15.0, (double)14.0, (double)8.5), DarkOakLampBlock.box((double)0.0, (double)7.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), DarkOakLampBlock.box((double)15.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), DarkOakLampBlock.box((double)1.0, (double)7.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0), DarkOakLampBlock.box((double)1.0, (double)7.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)DarkOakLampBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{DarkOakLampBlock.box((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)7.0, (double)1.0), DarkOakLampBlock.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0), DarkOakLampBlock.box((double)1.0, (double)13.0, (double)7.5, (double)15.0, (double)14.0, (double)8.5), DarkOakLampBlock.box((double)7.5, (double)13.0, (double)1.0, (double)8.5, (double)14.0, (double)15.0), DarkOakLampBlock.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), DarkOakLampBlock.box((double)0.0, (double)7.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), DarkOakLampBlock.box((double)0.0, (double)7.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0), DarkOakLampBlock.box((double)15.0, (double)7.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)DarkOakLampBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{DarkOakLampBlock.box((double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)7.0, (double)16.0), DarkOakLampBlock.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0), DarkOakLampBlock.box((double)1.0, (double)13.0, (double)7.5, (double)15.0, (double)14.0, (double)8.5), DarkOakLampBlock.box((double)7.5, (double)13.0, (double)1.0, (double)8.5, (double)14.0, (double)15.0), DarkOakLampBlock.box((double)0.0, (double)7.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), DarkOakLampBlock.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), DarkOakLampBlock.box((double)15.0, (double)7.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), DarkOakLampBlock.box((double)0.0, (double)7.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        LampBooleanDarkOakProcedure.execute((LevelAccessor)world, x, y, z, blockstate);
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockColorLoad(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().register((bs, world, pos, index) -> world != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.getDefaultColor(), new Block[]{(Block)CreepersDecoModBlocks.DARK_OAK_LAMP.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void itemColorLoad(RegisterColorHandlersEvent.Item event) {
        event.getItemColors().register((stack, index) -> FoliageColor.getDefaultColor(), new ItemLike[]{(ItemLike)CreepersDecoModBlocks.DARK_OAK_LAMP.get()});
    }
}

