/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creepersdeco.procedures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class KilnOnOnTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z) {
        double fireHeight = 0.0;
        if (world instanceof Level) {
            Level _level = (Level)world;
            if (!_level.isClientSide()) {
                _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.blastfurnace.fire_crackle")), SoundSource.NEUTRAL, 2.0f, 1.0f);
            } else {
                _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.blastfurnace.fire_crackle")), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
            }
        }
        if (Math.random() < 0.7) {
            if (KilnOnOnTickUpdateProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.NORTH) {
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, x + Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.3, (double)0.7), y + 0.2, z - 0.05, 0.0, 0.01, 0.0);
            } else if (KilnOnOnTickUpdateProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.SOUTH) {
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, x + Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.3, (double)0.7), y + 0.2, z + 1.05, 0.0, 0.01, 0.0);
            } else if (KilnOnOnTickUpdateProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.WEST) {
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, x - 0.05, y + 0.2, z + Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.3, (double)0.7), 0.0, 0.01, 0.0);
            } else if (KilnOnOnTickUpdateProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.EAST) {
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, x + 1.05, y + 0.2, z + Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.3, (double)0.7), 0.0, 0.01, 0.0);
            }
        }
    }

    private static Direction getBlockDirection(LevelAccessor world, BlockPos pos) {
        Comparable comparable;
        BlockState blockState = world.getBlockState(pos);
        Property property = blockState.getBlock().getStateDefinition().getProperty("facing");
        if (property != null && (comparable = blockState.getValue(property)) instanceof Direction) {
            Direction direction = (Direction)comparable;
            return direction;
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AXIS)) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        return Direction.NORTH;
    }
}

