include(Resources.id("jsblock:scripts/pids_util.js"));

function create(ctx, state, pids) {

}

function render(ctx, state, pids) {
    Texture.create("Background")
        .texture("jsblock:textures/paris_metro_pids_new.png")
        .size(pids.width, pids.height)
        .draw(ctx)

    let mergedDestinationsArray = []
    let arrivals = [0, 1].map(i => pids.arrivals().get(i))

    for (let i = 0; i < 2; i++) {
        let rowX = 13 + (i * 16.75);

        let arrival = pids.arrivals().get(i);
        if (arrival != null) {
            if (!mergedDestinationsArray.includes(arrival.destination()) && arrival.destination() !== undefined && arrival.destination() !== "undefined") {
                mergedDestinationsArray.push(arrival.destination())
            }

            arrivals.push(arrival.arrivalTime())
            /* if (i > 0 && !hasArrivalsArrayBeenReversed) {
                arrivals.reverse()
                hasArrivalsArrayBeenReversed = true
            } */

            if (i === 0) {
                if (arrival.routeNumber() !== undefined && arrival.routeNumber() !== null && arrival.routeNumber() !== "") {
                    Texture.create("Route number square")
                        .texture("jsblock:textures/square.png")
                        .color(arrival.routeColor())
                        .pos(rowX, 2)
                        .size(28, 14)
                        .draw(ctx);

                    Text.create("Route number text")
                        .text(arrival.routeNumber())
                        .scale(1.2)
                        .centerAlign()
                        .pos(rowX + 13, 5)
                        .draw(ctx);
                }

                Text.create("Arrival destination")
                    .text(mergedDestinationsArray[0])
                    .pos(rowX + 32, 5)
                    .color(0x000000)
                    .scale(1.25)
                    .draw(ctx);
            }

            let eta = Math.round((arrival.arrivalTime() - Date.now()) / 1000);
            let arrivalX;
            switch (i) {
                case 0:
                    arrivalX = pids.width - 120
                    break
                case 1:
                    arrivalX = pids.width - 50
                    break
            }
            Text.create("Arrival ETA")
                .text(Math.round(eta / 60))
                .pos(arrivalX, 32)
                .color(0xFFDD00)
                .scale(5)
                .draw(ctx);
        }
    }

    Text.create("Prochain / Next")
        .text("Prochain / Next")
        .pos(8, 21)
        .color(0xE1E1E1)
        .scale(0.5)
        .draw(ctx)

    Text.create("Suivant / Following")
        .text("Suivant / Following")
        .pos(84, 21)
        .color(0xE1E1E1)
        .scale(0.5)
        .draw(ctx)
}

function dispose(ctx, state, pids) {

}