/*
 * Decompiled with CFR 0.152.
 */
package swedzou.extrashow;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("ExtraShow").resolve("config.json");
    public List<List<List<String>>> data = new ArrayList<List<List<String>>>();
    private static ModConfig INSTANCE;

    public static ModConfig get() {
        if (INSTANCE == null) {
            ModConfig.load();
        }
        return INSTANCE;
    }

    public static void load() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                ModConfig.saveDefault();
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                Type type = new TypeToken<ModConfig>(){}.getType();
                INSTANCE = (ModConfig)GSON.fromJson((Reader)reader, type);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            INSTANCE = new ModConfig();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveDefault() {
        INSTANCE = new ModConfig();
        ArrayList<List<String>> Innerdata = new ArrayList<List<String>>();
        String[] name = new String[]{"default"};
        String[] buttonNames = new String[]{"Fps", "Player position", "Player orientation", "Camera position", "Camera orientation", "Position in current chunk", "Current chunk position", "Server player count", "Player in render distance", "Entities in render distance"};
        String[] inputText = new String[]{"Fps: (fps)", "Player position: (player.pos.x), (player.pos.y), (player.pos.z)", "Player orientation: (player.rotation.pitch), (player.rotation.yaw)", "Camera position: (camera.pos.x), (camera.pos.y), (camera.pos.z)", "Camera orientation: (camera.rotation.pitch), (camera.rotation.yaw)", "Position in current chunk: (player.pos.inChunk.x), (player.pos.inChunk.y), (player.pos.inChunk.z)", "Current chunk position: (player.pos.chunk.x), (player.pos.chunk.z)", "Player count: (server.players.count)", "Players in render distance: (render.entities.player.count)", "Entities in render distance: (render.entities.total.count)"};
        String[] CheckBoxesChecked = new String[]{"1", "1", "1", "1", "1", "1", "1", "1", "1", "1"};
        Innerdata.add(Arrays.asList(name));
        Innerdata.add(Arrays.asList(inputText));
        Innerdata.add(Arrays.asList(buttonNames));
        Innerdata.add(Arrays.asList(CheckBoxesChecked));
        ModConfig.INSTANCE.data.add(Innerdata);
        ModConfig.save();
    }
}

