/*
 * Decompiled with CFR 0.152.
 */
package com.pulse.datapacktools.main.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pulse.datapacktools.main.config.ConfigData;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/pulse/datapacktools/main/config/ModConfig;", "", "<init>", "()V", "", "save", "load", "init", "Ljava/io/File;", "configFile", "Ljava/io/File;", "getConfigFile", "()Ljava/io/File;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "Lcom/pulse/datapacktools/main/config/ConfigData;", "data", "Lcom/pulse/datapacktools/main/config/ConfigData;", "getData", "()Lcom/pulse/datapacktools/main/config/ConfigData;", "setData", "(Lcom/pulse/datapacktools/main/config/ConfigData;)V", "datapacktools"})
public final class ModConfig {
    @NotNull
    public static final ModConfig INSTANCE = new ModConfig();
    @NotNull
    private static final File configFile = new File("config/datapacktools.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    @NotNull
    private static ConfigData data = new ConfigData();

    private ModConfig() {
    }

    @NotNull
    public final File getConfigFile() {
        return configFile;
    }

    @NotNull
    public final ConfigData getData() {
        return data;
    }

    public final void setData(@NotNull ConfigData configData) {
        Intrinsics.checkNotNullParameter((Object)configData, (String)"<set-?>");
        data = configData;
    }

    public final void save() {
        String newData = gson.toJson((Object)data);
        Intrinsics.checkNotNull((Object)newData);
        FilesKt.writeText$default((File)configFile, (String)newData, null, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        if (configFile.exists() && ((CharSequence)FilesKt.readText$default((File)configFile, null, (int)1, null)).length() > 0) {
            try {
                Closeable closeable = new FileReader(configFile);
                Throwable throwable = null;
                try {
                    FileReader reader = (FileReader)closeable;
                    boolean bl = false;
                    ConfigData loadedData = (ConfigData)gson.fromJson((Reader)reader, ConfigData.class);
                    Intrinsics.checkNotNull((Object)loadedData);
                    data = loadedData;
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.init();
            }
        } else {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() {
        data = new ConfigData();
        configFile.getParentFile().mkdirs();
        Closeable closeable = new FileWriter(configFile);
        Throwable throwable = null;
        try {
            FileWriter writer = (FileWriter)closeable;
            boolean bl = false;
            gson.toJson((Object)data, (Appendable)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

