/*
 * Decompiled with CFR 0.152.
 */
package com.pulse.datapacktools.main.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pulse.datapacktools.main.config.ModConfig;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u001c\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/pulse/datapacktools/main/utils/DatapacksUtils;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "", "updateDatapack", "(Lnet/minecraft/class_3222;)V", "Ljava/io/File;", "rootDir", "createDefaultDatapack", "(Ljava/io/File;)V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "datapacktools"})
public final class DatapacksUtils {
    @NotNull
    public static final DatapacksUtils INSTANCE = new DatapacksUtils();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private DatapacksUtils() {
    }

    public final void updateDatapack(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MinecraftServer server = player.field_13995;
        class_3283 dataManager = server.method_3836();
        String keyName = "file/" + ModConfig.INSTANCE.getData().getDatapackName();
        if (ModConfig.INSTANCE.getData().getEnableAutomaticDatapackReload()) {
            Collection collection = dataManager.method_29210();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEnabledNames(...)");
            CollectionsKt.toMutableList((Collection)collection).remove(keyName);
            Collection collection2 = dataManager.method_29210();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getEnabledNames(...)");
            CollectionsKt.toMutableList((Collection)collection2).add(keyName);
            server.method_29439(dataManager.method_29210());
        }
    }

    public final void createDefaultDatapack(@NotNull File rootDir) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        File convertedPackDir = new File(rootDir, "datapacks/" + ModConfig.INSTANCE.getData().getDatapackName());
        File functionsDir = new File(convertedPackDir, "data/" + ModConfig.INSTANCE.getData().getDatapackNamespace() + "/functions");
        if (!convertedPackDir.exists()) {
            convertedPackDir.mkdirs();
            functionsDir.mkdirs();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"pack_format", (Object)18), TuplesKt.to((Object)"description", (Object)"Datapack by DatapackTools")};
            String packGson = gson.toJson((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"pack", (Object)MapsKt.mapOf((Pair[])pairArray))));
            File file = new File(convertedPackDir, "pack.mcmeta");
            Intrinsics.checkNotNull((Object)packGson);
            FilesKt.writeText$default((File)file, (String)packGson, null, (int)2, null);
        } else if (!functionsDir.exists()) {
            functionsDir.mkdirs();
        }
    }
}

