/*
 * Decompiled with CFR 0.152.
 */
package com.pulse.datapacktools.main.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u001c\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/pulse/datapacktools/main/utils/DatapacksUtils;", "", "<init>", "()V", "Ljava/io/File;", "rootDir", "", "createDefaultDatapack", "(Ljava/io/File;)V", "", "DATAPACK_NAME", "Ljava/lang/String;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "datapacktools"})
public final class DatapacksUtils {
    @NotNull
    public static final DatapacksUtils INSTANCE = new DatapacksUtils();
    @NotNull
    public static final String DATAPACK_NAME = "converted";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private DatapacksUtils() {
    }

    public final void createDefaultDatapack(@NotNull File rootDir) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        File convertedPackDir = new File(rootDir, "datapacks/converted");
        File functionsDir = new File(convertedPackDir, "data/converted/functions");
        if (!convertedPackDir.exists()) {
            convertedPackDir.mkdirs();
            functionsDir.mkdirs();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"pack_format", (Object)18), TuplesKt.to((Object)"description", (Object)"Datapack by DatapackTools")};
            String packGson = gson.toJson((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"pack", (Object)MapsKt.mapOf((Pair[])pairArray))));
            File file = new File(convertedPackDir, "pack.mcmeta");
            Intrinsics.checkNotNull((Object)packGson);
            FilesKt.writeText$default((File)file, (String)packGson, null, (int)2, null);
        } else if (!functionsDir.exists()) {
            functionsDir.mkdirs();
        }
    }
}

