/*
 * Decompiled with CFR 0.152.
 */
package net.gnomecraft.ductwork.collector;

import com.mojang.serialization.MapCodec;
import net.gnomecraft.ductwork.Ductwork;
import net.gnomecraft.ductwork.base.DuctworkBlock;
import net.gnomecraft.ductwork.collector.CollectorEntity;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_9904;

public class CollectorBlock
extends DuctworkBlock {
    public static final MapCodec<CollectorBlock> CODEC = CollectorBlock.method_54094(CollectorBlock::new);
    public static final class_265[] COLLECTOR_SHAPE_DICT = new class_265[512];

    public CollectorBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11033)).method_11657((class_2769)INTAKE, (Comparable)class_2350.field_11036)).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(true)));
        if (COLLECTOR_SHAPE_DICT[0] == null) {
            CollectorBlock.buildShapeDict();
        }
    }

    protected MapCodec<CollectorBlock> method_53969() {
        return CODEC;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CollectorEntity(pos, state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return CollectorBlock.method_31618(type, Ductwork.COLLECTOR_ENTITY, CollectorEntity::tick);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.method_8608()) return class_1269.field_5812;
        class_1799 mainStack = player.method_6047();
        if (player.method_5715()) {
            if (mainStack.method_31574(class_1802.field_8600)) {
                this.reorient(state, world, pos, this.getNextOrientation(state, (class_2754<class_2350>)FACING, (class_2754<class_2350>)INTAKE));
                return class_1269.field_5812;
            } else {
                if (!mainStack.method_7960()) return class_1269.field_5811;
                this.reorientIntake(state, world, pos, this.getNextOrientation(state, (class_2754<class_2350>)INTAKE, (class_2754<class_2350>)FACING));
            }
            return class_1269.field_5812;
        } else if (mainStack.method_31573(Ductwork.WRENCHES)) {
            this.reorient(state, world, pos, this.getNextOrientation(state, (class_2754<class_2350>)FACING, (class_2754<class_2350>)INTAKE));
            return class_1269.field_5812;
        } else {
            if (Ductwork.getConfig().placement && mainStack.method_31573(Ductwork.DUCT_ITEMS)) {
                return class_1269.field_5811;
            }
            this.openContainer(world, pos, player);
        }
        return class_1269.field_5812;
    }

    @Override
    protected void reorient(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        class_2350 previous = (class_2350)state.method_11654((class_2769)FACING);
        if (!direction.equals((Object)previous)) {
            class_2680 neighbor1 = world.method_8320(pos.method_10093(previous));
            class_2680 neighbor2 = world.method_8320(pos.method_10093(direction));
            state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)direction);
            state = this.getStateWithNeighbor(state, previous, neighbor1);
            state = this.getStateWithNeighbor(state, direction, neighbor2);
            world.method_8652(pos, state, 6);
        }
    }

    protected void reorientIntake(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        class_2350 previous = (class_2350)state.method_11654((class_2769)INTAKE);
        if (!direction.equals((Object)previous)) {
            class_2680 neighbor1 = world.method_8320(pos.method_10093(previous));
            class_2680 neighbor2 = world.method_8320(pos.method_10093(direction));
            state = (class_2680)state.method_11657((class_2769)INTAKE, (Comparable)direction);
            state = this.getStateWithNeighbor(state, previous, neighbor1);
            state = this.getStateWithNeighbor(state, direction, neighbor2);
            world.method_8652(pos, state, 7);
        }
    }

    private void openContainer(class_1937 world, class_2338 blockPos, class_1657 playerEntity) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof CollectorEntity) {
            playerEntity.method_17355((class_3908)blockEntity);
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 intake = ctx.method_8038();
        class_2350 facing = intake.method_10153();
        if (Ductwork.getConfig().vanilla) {
            intake = class_2350.field_11036;
            if (facing == class_2350.field_11036) {
                facing = class_2350.field_11033;
            }
        }
        class_2680 state = (class_2680)((class_2680)super.addPlacementState((class_2680)this.field_10647.method_11664(), ctx).method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)INTAKE, (Comparable)intake);
        state = this.resetInputConnections(state, ctx.method_8045(), ctx.method_8037());
        return state;
    }

    @Override
    protected class_2680 resetInputConnections(class_2680 state, class_1937 world, class_2338 pos) {
        return super.resetInputConnections(state, world, pos);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (world != null && !oldState.method_27852(state.method_26204())) {
            this.updateEnabled(world, pos, state);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_9904 wireOrientation, boolean notify) {
        if (world != null) {
            this.updateEnabled(world, pos, state);
        }
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        class_2680 newState = (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(!world.method_49803(pos)));
        newState = super.method_9559(newState, world, tickView, pos, direction, neighborPos, neighborState, random);
        newState = this.getStateWithNeighbor(newState, direction, neighborState);
        return newState;
    }

    private void updateEnabled(class_1937 world, class_2338 pos, class_2680 state) {
        boolean enabled;
        boolean bl = enabled = !world.method_49803(pos);
        if (enabled != (Boolean)state.method_11654((class_2769)ENABLED)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(enabled)), 4);
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, INTAKE, NORTH, EAST, SOUTH, WEST, DOWN, UP, ENABLED});
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)))).method_11657((class_2769)INTAKE, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)INTAKE)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int shapeId = ((class_2350)state.method_11654((class_2769)INTAKE)).method_10146() << 6;
        switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case field_11043: {
                shapeId |= 1;
                break;
            }
            case field_11034: {
                shapeId |= 2;
                break;
            }
            case field_11035: {
                shapeId |= 4;
                break;
            }
            case field_11039: {
                shapeId |= 8;
                break;
            }
            case field_11033: {
                shapeId |= 0x10;
                break;
            }
            case field_11036: {
                shapeId |= 0x20;
            }
        }
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            shapeId |= 1;
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            shapeId |= 2;
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            shapeId |= 4;
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            shapeId |= 8;
        }
        if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
            shapeId |= 0x10;
        }
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            shapeId |= 0x20;
        }
        return COLLECTOR_SHAPE_DICT[shapeId];
    }

    private static void buildShapeDict() {
        class_265[] INTAKE_SHAPES = new class_265[6];
        class_265[] ADJACENT_SHAPES = new class_265[6];
        class_265 CENTER_SHAPE = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
        INTAKE_SHAPES[class_2350.field_11043.method_10146()] = class_259.method_17786((class_265)CENTER_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)5.0)});
        INTAKE_SHAPES[class_2350.field_11034.method_10146()] = class_259.method_17786((class_265)CENTER_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)11.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)});
        INTAKE_SHAPES[class_2350.field_11035.method_10146()] = class_259.method_17786((class_265)CENTER_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)4.0, (double)4.0, (double)11.0, (double)12.0, (double)12.0, (double)12.0)});
        INTAKE_SHAPES[class_2350.field_11039.method_10146()] = class_259.method_17786((class_265)CENTER_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)12.0)});
        INTAKE_SHAPES[class_2350.field_11033.method_10146()] = class_259.method_17786((class_265)CENTER_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0)});
        INTAKE_SHAPES[class_2350.field_11036.method_10146()] = class_259.method_17786((class_265)CENTER_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)});
        ADJACENT_SHAPES[class_2350.field_11043.method_10146()] = class_2248.method_9541((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0);
        ADJACENT_SHAPES[class_2350.field_11034.method_10146()] = class_2248.method_9541((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
        ADJACENT_SHAPES[class_2350.field_11035.method_10146()] = class_2248.method_9541((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0);
        ADJACENT_SHAPES[class_2350.field_11039.method_10146()] = class_2248.method_9541((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
        ADJACENT_SHAPES[class_2350.field_11033.method_10146()] = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
        ADJACENT_SHAPES[class_2350.field_11036.method_10146()] = class_2248.method_9541((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
        for (class_2350 intake : field_23157) {
            int intakeId = intake.method_10146();
            for (int adjacents = 0; adjacents < 64; ++adjacents) {
                CollectorBlock.COLLECTOR_SHAPE_DICT[intakeId << 6 | adjacents] = class_259.method_17786((class_265)INTAKE_SHAPES[intakeId], (class_265[])new class_265[]{(adjacents & 1) != 0 ? ADJACENT_SHAPES[class_2350.field_11043.method_10146()] : class_259.method_1073(), (adjacents & 2) != 0 ? ADJACENT_SHAPES[class_2350.field_11034.method_10146()] : class_259.method_1073(), (adjacents & 4) != 0 ? ADJACENT_SHAPES[class_2350.field_11035.method_10146()] : class_259.method_1073(), (adjacents & 8) != 0 ? ADJACENT_SHAPES[class_2350.field_11039.method_10146()] : class_259.method_1073(), (adjacents & 0x10) != 0 ? ADJACENT_SHAPES[class_2350.field_11033.method_10146()] : class_259.method_1073(), (adjacents & 0x20) != 0 ? ADJACENT_SHAPES[class_2350.field_11036.method_10146()] : class_259.method_1073()});
            }
        }
    }
}

