/*
 * Decompiled with CFR 0.152.
 */
package net.gnomecraft.ductwork.collector;

import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.gnomecraft.cooldowncoordinator.CooldownCoordinator;
import net.gnomecraft.ductwork.Ductwork;
import net.gnomecraft.ductwork.base.DuctworkBlockEntity;
import net.gnomecraft.ductwork.collector.CollectorBlock;
import net.gnomecraft.ductwork.collector.CollectorScreenHandler;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;

public class CollectorEntity
extends DuctworkBlockEntity
implements class_2615 {
    public static final int currentBlockRev = 2;
    private int blockRev;
    private static final class_238 INPUT_AREA_SHAPE_NORTH = (class_238)class_2248.method_9541((double)0.0, (double)0.0, (double)-16.0, (double)16.0, (double)16.0, (double)0.0).method_1090().get(0);
    private static final class_238 INPUT_AREA_SHAPE_EAST = (class_238)class_2248.method_9541((double)16.0, (double)0.0, (double)0.0, (double)32.0, (double)16.0, (double)16.0).method_1090().get(0);
    private static final class_238 INPUT_AREA_SHAPE_SOUTH = (class_238)class_2248.method_9541((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0, (double)32.0).method_1090().get(0);
    private static final class_238 INPUT_AREA_SHAPE_WEST = (class_238)class_2248.method_9541((double)-16.0, (double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0).method_1090().get(0);
    private static final class_238 INPUT_AREA_SHAPE_DOWN = (class_238)class_2248.method_9541((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0).method_1090().get(0);
    private static final class_238 INPUT_AREA_SHAPE_UP = (class_238)class_2248.method_9541((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0).method_1090().get(0);

    public CollectorEntity(class_2338 pos, class_2680 state) {
        super(Ductwork.COLLECTOR_ENTITY, pos, state);
        this.inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
        this.transferCooldown = 0;
        this.blockRev = -1;
    }

    public class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new CollectorScreenHandler(syncId, playerInventory, this);
    }

    @Override
    protected void method_11007(class_11372 view) {
        if (this.blockRev >= 0) {
            view.method_71465("BlockRev", this.blockRev);
        }
        super.method_11007(view);
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.blockRev = view.method_71424("BlockRev", 0);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CollectorEntity entity) {
        boolean dirty = false;
        if (world == null || world.method_8608()) {
            return;
        }
        if (2 > entity.blockRev) {
            switch (entity.blockRev) {
                case -1: {
                    entity.blockRev = 2;
                    break;
                }
                case 0: {
                    class_2350 intake = ((class_2350)state.method_11654((class_2769)CollectorBlock.FACING)).method_10153();
                    Ductwork.LOGGER.info("Collector at (" + pos.method_23854() + ") has BlockRev " + entity.blockRev + "; setting INTAKE to " + String.valueOf(intake));
                    world.method_8501(pos, (class_2680)state.method_11657((class_2769)CollectorBlock.INTAKE, (Comparable)intake));
                    entity.blockRev = 1;
                }
                case 1: {
                    world.method_8501(pos, ((CollectorBlock)state.method_26204()).resetInputConnections(state, world, pos));
                    entity.blockRev = 2;
                }
                default: {
                    if (entity.blockRev == 2) break;
                    Ductwork.LOGGER.warn("Collector at " + String.valueOf(pos) + " has rev " + entity.blockRev + " but our latest known rev is 2 ... expect trouble!");
                }
            }
            dirty = true;
        }
        entity.lastTickTime = world.method_75260();
        if (entity.transferCooldown > 0) {
            --entity.transferCooldown;
            dirty = true;
        }
        if (((Boolean)state.method_11654((class_2769)CollectorBlock.ENABLED)).booleanValue() && entity.transferCooldown <= 0) {
            if (!entity.method_5442() && entity.push(world, pos, state, entity)) {
                entity.transferCooldown = 8;
                dirty = true;
            }
            if (!entity.isFull() && entity.pull(world, pos, state, entity)) {
                entity.transferCooldown = 8;
                dirty = true;
            }
        }
        if (dirty) {
            entity.method_5431();
        }
    }

    private boolean push(class_1937 world, class_2338 pos, class_2680 state, CollectorEntity entity) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)CollectorBlock.FACING);
        class_2586 targetEntity = world.method_8321(pos.method_10093(facing));
        Storage sourceStorage = (Storage)ItemStorage.SIDED.find(world, pos, state, (class_2586)entity, (Object)facing);
        Storage targetStorage = (Storage)ItemStorage.SIDED.find(world, pos.method_10093(facing), (Object)facing.method_10153());
        if (sourceStorage != null && targetStorage != null) {
            boolean targetEmpty = CooldownCoordinator.isStorageEmpty((Storage)targetStorage);
            if (StorageUtil.move((Storage)sourceStorage, (Storage)targetStorage, variant -> true, (long)1L, null) > 0L) {
                if (targetEmpty) {
                    CooldownCoordinator.notify((class_2586)targetEntity);
                }
                if (targetEntity != null) {
                    targetEntity.method_5431();
                }
                return true;
            }
        }
        return false;
    }

    private boolean pull(class_1937 world, class_2338 pos, class_2680 state, CollectorEntity entity) {
        class_1263 sourceInventory;
        class_2350 intake = (class_2350)state.method_11654((class_2769)CollectorBlock.INTAKE);
        class_2338 sourcePos = pos.method_10093(intake);
        Storage targetStorage = (Storage)ItemStorage.SIDED.find(world, pos, state, (class_2586)entity, (Object)intake);
        Storage sourceStorage = (Storage)ItemStorage.SIDED.find(world, sourcePos, (Object)intake.method_10153());
        if (sourceStorage == null && (sourceInventory = class_2614.method_11250((class_1937)world, (class_2338)sourcePos)) != null) {
            sourceStorage = InventoryStorage.of((class_1263)sourceInventory, (class_2350)intake.method_10153());
        }
        if (sourceStorage != null && targetStorage != null) {
            boolean result = StorageUtil.move((Storage)sourceStorage, (Storage)targetStorage, variant -> true, (long)1L, null) > 0L;
            class_2586 sourceEntity = world.method_8321(sourcePos);
            if (sourceEntity != null) {
                sourceEntity.method_5431();
            }
            return result;
        }
        class_2680 sourceState = world.method_8320(sourcePos);
        if (!sourceState.method_26234((class_1922)world, sourcePos) || sourceState.method_26164(class_3481.field_49147)) {
            for (class_1542 itemEntity : class_2614.method_11237((class_1937)world, (class_2615)entity)) {
                if (!class_2614.method_11247((class_1263)entity, (class_1542)itemEntity)) continue;
                return true;
            }
        }
        return false;
    }

    public class_238 method_11262() {
        return switch ((class_2350)this.method_11010().method_11654((class_2769)CollectorBlock.INTAKE)) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043 -> INPUT_AREA_SHAPE_NORTH;
            case class_2350.field_11034 -> INPUT_AREA_SHAPE_EAST;
            case class_2350.field_11035 -> INPUT_AREA_SHAPE_SOUTH;
            case class_2350.field_11039 -> INPUT_AREA_SHAPE_WEST;
            case class_2350.field_11033 -> INPUT_AREA_SHAPE_DOWN;
            case class_2350.field_11036 -> INPUT_AREA_SHAPE_UP;
        };
    }

    public double method_11266() {
        return (double)this.field_11867.method_10263() + 0.5;
    }

    public double method_11264() {
        return (double)this.field_11867.method_10264() + 0.5;
    }

    public double method_11265() {
        return (double)this.field_11867.method_10260() + 0.5;
    }

    public boolean method_57081() {
        return false;
    }
}

