/*
 * Decompiled with CFR 0.152.
 */
package net.gnomecraft.ductwork.compat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.gnomecraft.ductwork.compat.BasaltCrusherNeighborChecks;
import net.gnomecraft.ductwork.compat.CreateNeighborChecks;
import net.gnomecraft.ductwork.compat.DuctsModNeighborChecks;
import net.gnomecraft.ductwork.compat.DuctworkNeighborChecks;
import net.gnomecraft.ductwork.compat.FlytresPipeModNeighborChecks;
import net.gnomecraft.ductwork.compat.OmniHopperNeighborChecks;
import net.gnomecraft.ductwork.compat.SimplePipesNeighborChecks;
import net.gnomecraft.ductwork.compat.SmartPipesNeighborChecks;
import net.gnomecraft.ductwork.compat.VanillaNeighborChecks;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.apache.commons.lang3.function.TriFunction;

public abstract class NeighborChecks {
    private static final Collection<TriFunction<class_2680, class_2248, class_2350, Boolean>> NEIGHBOR_CHECKS = new ArrayList<TriFunction<class_2680, class_2248, class_2350, Boolean>>(16);
    private final String modId;

    protected NeighborChecks(String modId) {
        this.modId = modId;
    }

    public final void register(Consumer<TriFunction<class_2680, class_2248, class_2350, Boolean>> registry) {
        if (FabricLoader.getInstance().isModLoaded(this.modId)) {
            this.registerChecks(registry);
        }
    }

    protected abstract void registerChecks(Consumer<TriFunction<class_2680, class_2248, class_2350, Boolean>> var1);

    protected class_2960 id(String path) {
        return class_2960.method_60655((String)this.modId, (String)path);
    }

    public static void init() {
        new DuctworkNeighborChecks().register(NEIGHBOR_CHECKS::add);
        new VanillaNeighborChecks().register(NEIGHBOR_CHECKS::add);
        new BasaltCrusherNeighborChecks().register(NEIGHBOR_CHECKS::add);
        new CreateNeighborChecks().register(NEIGHBOR_CHECKS::add);
        new DuctsModNeighborChecks().register(NEIGHBOR_CHECKS::add);
        new OmniHopperNeighborChecks().register(NEIGHBOR_CHECKS::add);
        new FlytresPipeModNeighborChecks().register(NEIGHBOR_CHECKS::add);
        new SimplePipesNeighborChecks().register(NEIGHBOR_CHECKS::add);
        new SmartPipesNeighborChecks().register(NEIGHBOR_CHECKS::add);
    }

    public static boolean checkNeighbor(class_2680 neighbor, class_2350 facing) {
        class_2248 neighborBlock = neighbor.method_26204();
        for (TriFunction<class_2680, class_2248, class_2350, Boolean> check : NEIGHBOR_CHECKS) {
            if (!((Boolean)check.apply((Object)neighbor, (Object)neighborBlock, (Object)facing)).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

