/*
 * Decompiled with CFR 0.152.
 */
package net.gnomecraft.ductwork.damper;

import com.mojang.serialization.MapCodec;
import net.gnomecraft.ductwork.Ductwork;
import net.gnomecraft.ductwork.base.DuctworkBlock;
import net.gnomecraft.ductwork.damper.DamperEntity;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_9904;

public class DamperBlock
extends DuctworkBlock {
    public static final MapCodec<DamperBlock> CODEC = DamperBlock.method_54094(DamperBlock::new);
    private static final class_265 DAMPER_SHAPE_NS_ENABLED = class_259.method_17786((class_265)class_2248.method_9541((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)7.0, (double)4.0, (double)5.0, (double)9.0, (double)12.0), class_2248.method_9541((double)11.0, (double)7.0, (double)4.0, (double)13.0, (double)9.0, (double)12.0)});
    private static final class_265 DAMPER_SHAPE_NS_DISABLED = class_259.method_17786((class_265)class_2248.method_9541((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)4.0, (double)7.0, (double)5.0, (double)12.0, (double)9.0), class_2248.method_9541((double)11.0, (double)4.0, (double)7.0, (double)13.0, (double)12.0, (double)9.0)});
    private static final class_265 DAMPER_SHAPE_EW_ENABLED = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (class_265[])new class_265[]{class_2248.method_9541((double)4.0, (double)7.0, (double)3.0, (double)12.0, (double)9.0, (double)5.0), class_2248.method_9541((double)4.0, (double)7.0, (double)11.0, (double)12.0, (double)9.0, (double)13.0)});
    private static final class_265 DAMPER_SHAPE_EW_DISABLED = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (class_265[])new class_265[]{class_2248.method_9541((double)7.0, (double)4.0, (double)3.0, (double)9.0, (double)12.0, (double)5.0), class_2248.method_9541((double)7.0, (double)4.0, (double)11.0, (double)9.0, (double)12.0, (double)13.0)});
    private static final class_265 DAMPER_SHAPE_DU_ENABLED = class_259.method_17786((class_265)class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)4.0, (double)7.0, (double)5.0, (double)12.0, (double)9.0), class_2248.method_9541((double)11.0, (double)4.0, (double)7.0, (double)13.0, (double)12.0, (double)9.0)});
    private static final class_265 DAMPER_SHAPE_DU_DISABLED = class_259.method_17786((class_265)class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)7.0, (double)4.0, (double)5.0, (double)9.0, (double)12.0), class_2248.method_9541((double)11.0, (double)7.0, (double)4.0, (double)13.0, (double)9.0, (double)12.0)});

    public DamperBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11033)).method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<DamperBlock> method_53969() {
        return CODEC;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DamperEntity(pos, state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return DamperBlock.method_31618(type, Ductwork.DAMPER_ENTITY, DamperEntity::tick);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.method_8608()) return class_1269.field_5812;
        class_1799 mainStack = player.method_6047();
        if (player.method_5715()) {
            if (mainStack.method_31574(class_1802.field_8600)) {
                this.reorient(state, world, pos, this.getNextOrientation(state, (class_2754<class_2350>)FACING, null));
                return class_1269.field_5812;
            } else {
                if (!mainStack.method_7960() || Ductwork.getConfig().vanilla) return class_1269.field_5811;
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)ENABLED) == false)), 4);
            }
            return class_1269.field_5812;
        } else if (mainStack.method_31573(Ductwork.WRENCHES)) {
            this.reorient(state, world, pos, this.getNextOrientation(state, (class_2754<class_2350>)FACING, null));
            return class_1269.field_5812;
        } else {
            if (Ductwork.getConfig().placement && mainStack.method_31573(Ductwork.DUCT_ITEMS)) {
                return class_1269.field_5811;
            }
            this.openContainer(world, pos, player);
        }
        return class_1269.field_5812;
    }

    private void openContainer(class_1937 world, class_2338 blockPos, class_1657 playerEntity) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof DamperEntity) {
            playerEntity.method_17355((class_3908)blockEntity);
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = ctx.method_8038().method_10153();
        if (Ductwork.getConfig().vanilla && facing == class_2350.field_11036) {
            facing = class_2350.field_11033;
        }
        class_2680 state = (class_2680)super.addPlacementState((class_2680)this.field_10647.method_11664(), ctx).method_11657((class_2769)FACING, (Comparable)facing);
        return state;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (world != null && !oldState.method_27852(state.method_26204())) {
            this.updateEnabled(world, pos, state);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_9904 wireOrientation, boolean notify) {
        if (world != null) {
            this.updateEnabled(world, pos, state);
        }
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        class_2680 newState = (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(!world.method_49803(pos)));
        newState = super.method_9559(newState, world, tickView, pos, direction, neighborPos, neighborState, random);
        return newState;
    }

    private void updateEnabled(class_1937 world, class_2338 pos, class_2680 state) {
        boolean enabled;
        boolean bl = enabled = !world.method_49803(pos);
        if (enabled != (Boolean)state.method_11654((class_2769)ENABLED)) {
            class_2680 newState = (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(enabled));
            world.method_8652(pos, newState, 2);
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, ENABLED});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        boolean enabled = (Boolean)state.method_11654((class_2769)ENABLED);
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11043, class_2350.field_11035 -> {
                if (enabled) {
                    yield DAMPER_SHAPE_NS_ENABLED;
                }
                yield DAMPER_SHAPE_NS_DISABLED;
            }
            case class_2350.field_11034, class_2350.field_11039 -> {
                if (enabled) {
                    yield DAMPER_SHAPE_EW_ENABLED;
                }
                yield DAMPER_SHAPE_EW_DISABLED;
            }
            default -> enabled ? DAMPER_SHAPE_DU_ENABLED : DAMPER_SHAPE_DU_DISABLED;
        };
    }
}

