/*
 * Decompiled with CFR 0.152.
 */
package net.gnomecraft.ductwork.fabricresourcecondition;

import java.lang.reflect.Field;
import java.util.List;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.gnomecraft.ductwork.Ductwork;
import net.gnomecraft.ductwork.fabricresourcecondition.AllConfigBooleansEnabledResourceCondition;
import net.gnomecraft.ductwork.fabricresourcecondition.AnyConfigBooleansEnabledResourceCondition;
import net.gnomecraft.ductwork.fabricresourcecondition.DuctworkResourceConditionTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuctworkResourceConditions {
    private DuctworkResourceConditions() {
    }

    public static ResourceCondition allConfigBooleansEnabled(String ... configBooleans) {
        return new AllConfigBooleansEnabledResourceCondition(List.of(configBooleans));
    }

    public static ResourceCondition anyConfigBooleansEnabled(String ... configBooleans) {
        return new AnyConfigBooleansEnabledResourceCondition(List.of(configBooleans));
    }

    public static void init() {
        ResourceConditions.register(DuctworkResourceConditionTypes.ALL_CONFIG_BOOLEANS_ENABLED);
        ResourceConditions.register(DuctworkResourceConditionTypes.ANY_CONFIG_BOOLEANS_ENABLED);
    }

    static boolean configBooleansEnabled(List<String> configBooleans, boolean and) {
        for (String configBoolean : configBooleans) {
            if (DuctworkResourceConditions.getConfigBooleanByName(Ductwork.getConfig(), configBoolean) == and) continue;
            return !and;
        }
        return and;
    }

    @Nullable
    private static Object getConfigFieldByName(@NotNull Object config, @NotNull String name) {
        try {
            Field field = config.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return field.get(config);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static boolean getConfigBooleanByName(@NotNull Object config, @NotNull String name) {
        Object value = DuctworkResourceConditions.getConfigFieldByName(config, name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        Ductwork.LOGGER.warn("ResourceCondition requested invalid boolean config option: {}", (Object)name);
        return false;
    }
}

