/*
 * Decompiled with CFR 0.152.
 */
package org.firedragon91245.bounty_enchantment;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.firedragon91245.bounty_enchantment.BountyEnchantmentMod;

public final class BountyEnchantmentConfig {
    public static final String MOD_VERSION = "1.0.0";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public double[] levelMultipliers;
    public int maxXpCap;
    public boolean allowOffhand;
    public boolean debug;

    public static BountyEnchantmentConfig loadOrCreate() {
        BountyEnchantmentConfig bountyEnchantmentConfig;
        block18: {
            Path cfgDir = FabricLoader.getInstance().getConfigDir();
            Path cfgPath = cfgDir.resolve(String.format("%s.json", "bounty_enchantment"));
            if (!Files.exists(cfgPath, new LinkOption[0])) {
                BountyEnchantmentConfig cfg = BountyEnchantmentConfig.defaults();
                try {
                    Files.createDirectories(cfgDir, new FileAttribute[0]);
                    try (BufferedWriter w = Files.newBufferedWriter(cfgPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                        GSON.toJson((Object)cfg, (Appendable)w);
                    }
                    BountyEnchantmentMod.LOG.info("[{}] Wrote default config at {}", (Object)"bounty_enchantment", (Object)cfgPath);
                }
                catch (IOException e) {
                    BountyEnchantmentMod.LOG.error("[{}] Failed to write default config", (Object)"bounty_enchantment", (Object)e);
                }
                return cfg;
            }
            BufferedReader r = Files.newBufferedReader(cfgPath, StandardCharsets.UTF_8);
            try {
                BountyEnchantmentConfig cfg = (BountyEnchantmentConfig)GSON.fromJson((Reader)r, BountyEnchantmentConfig.class);
                bountyEnchantmentConfig = BountyEnchantmentConfig.sanitize(cfg);
                if (r == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    BountyEnchantmentMod.LOG.error("[{}] Failed to read config; using defaults", (Object)"bounty_enchantment", (Object)e);
                    return BountyEnchantmentConfig.defaults();
                }
            }
            r.close();
        }
        return bountyEnchantmentConfig;
    }

    private static BountyEnchantmentConfig defaults() {
        BountyEnchantmentConfig c = new BountyEnchantmentConfig();
        c.levelMultipliers = new double[]{1.25, 1.5, 1.75, 2.0, 2.5};
        c.maxXpCap = Short.MAX_VALUE;
        c.allowOffhand = false;
        c.debug = false;
        return c;
    }

    private static BountyEnchantmentConfig sanitize(BountyEnchantmentConfig c) {
        if (c == null) {
            return BountyEnchantmentConfig.defaults();
        }
        if (c.levelMultipliers == null || c.levelMultipliers.length != 5) {
            BountyEnchantmentMod.LOG.warn("[{}] levelMultipliers invalid; resetting to defaults", (Object)"bounty_enchantment");
            c.levelMultipliers = BountyEnchantmentConfig.defaults().levelMultipliers;
        }
        for (int i = 0; i < c.levelMultipliers.length; ++i) {
            if (Double.isNaN(c.levelMultipliers[i]) || Double.isInfinite(c.levelMultipliers[i])) {
                c.levelMultipliers[i] = 1.0;
            }
            if (!(c.levelMultipliers[i] < 0.0)) continue;
            c.levelMultipliers[i] = 0.0;
        }
        if (c.maxXpCap < 0) {
            c.maxXpCap = BountyEnchantmentConfig.defaults().maxXpCap;
        }
        return c;
    }

    public String prettyMultipliers() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.levelMultipliers.length; ++i) {
            sb.append(this.levelMultipliers[i]);
            if (i + 1 >= this.levelMultipliers.length) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

