/*
 * Decompiled with CFR 0.152.
 */
package org.firedragon91245.bounty_enchantment.mixin;

import java.util.Optional;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.firedragon91245.bounty_enchantment.BountyEnchantmentMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_1309.class})
public abstract class LivingEntityBountyXpBonusMixin {
    @Redirect(method={"method_23883(Lnet/minecraft/class_3218;Lnet/minecraft/class_1297;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1303;method_31493(Lnet/minecraft/class_3218;Lnet/minecraft/class_243;I)V"))
    private void bounty$spawnWithBonus(class_3218 world, class_243 pos, int vanillaAmount) {
        int resultAmount = vanillaAmount;
        class_1309 self = (class_1309)this;
        if (world == null || vanillaAmount <= 0) {
            class_1303.method_31493((class_3218)world, (class_243)pos, (int)resultAmount);
            return;
        }
        class_1309 attacker = self.method_6065();
        if (attacker instanceof class_1657) {
            class_1657 killer = (class_1657)attacker;
            class_2378 enchantReg = world.method_30349().method_30530(class_7924.field_41265);
            Optional bountyOpt = enchantReg.method_10223(BountyEnchantmentMod.BOUNTY.method_29177());
            if (bountyOpt.isPresent()) {
                int level;
                class_6880 bounty = (class_6880)bountyOpt.get();
                if (BountyEnchantmentMod.CONFIG.allowOffhand) {
                    level = class_1890.method_8203((class_6880)bounty, (class_1309)killer);
                } else {
                    class_1799 main = killer.method_6047();
                    level = class_1890.method_8225((class_6880)bounty, (class_1799)main);
                }
                if (level > 0) {
                    double[] multipliers = BountyEnchantmentMod.CONFIG.levelMultipliers;
                    if (level > multipliers.length) {
                        level = multipliers.length - 1;
                    }
                    double multiplier = multipliers[level - 1];
                    long newAmount = LivingEntityBountyXpBonusMixin.getNewAmount(vanillaAmount, multiplier);
                    resultAmount = (int)newAmount;
                    if (BountyEnchantmentMod.CONFIG.debug) {
                        BountyEnchantmentMod.LOG.info("[XPBoost] {} base={} level={} multiplier={} result={}", new Object[]{self.method_5477().getString(), vanillaAmount, level, multiplier, resultAmount});
                    }
                }
            }
        }
        class_1303.method_31493((class_3218)world, (class_243)pos, (int)resultAmount);
    }

    @Unique
    private static long getNewAmount(int vanillaAmount, double multiplier) {
        long newAmount;
        long capped = Math.round((double)vanillaAmount * (multiplier - 1.0));
        if (BountyEnchantmentMod.CONFIG.maxXpCap > 0 && capped > (long)BountyEnchantmentMod.CONFIG.maxXpCap) {
            capped = BountyEnchantmentMod.CONFIG.maxXpCap;
        }
        if ((newAmount = (long)vanillaAmount + Math.max(0L, capped)) > Integer.MAX_VALUE) {
            newAmount = Integer.MAX_VALUE;
        }
        return newAmount;
    }
}

