/*
 * Decompiled with CFR 0.152.
 */
package com.example.schematicsfix;

import com.example.schematicsfix.Config;
import com.example.schematicsfix.SchematicWatcher;
import com.example.schematicsfix.commands.ScanAllCommand;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@Mod(value="schematicsfix")
public class SchematicFixMod {
    public static final String MODID = "schematicsfix";
    public static final Path SCHEMATICS_DIR = FMLPaths.GAMEDIR.get().resolve("schematics");
    public static final Path UPLOADED_DIR = SCHEMATICS_DIR.resolve("uploaded");
    public static final Path ANOMALY_DIR = SCHEMATICS_DIR.resolve("anomaly");
    private SchematicWatcher watcher;

    public SchematicFixMod(IEventBus modEventBus, ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        this.watcher = new SchematicWatcher(server, UPLOADED_DIR);
        this.watcher.startWatching();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ScanAllCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        if (this.watcher != null) {
            this.watcher.stopWatching();
        }
    }
}

