/*
 * Decompiled with CFR 0.152.
 */
package com.example.schematicsfix;

import com.example.schematicsfix.Config;
import com.example.schematicsfix.SchematicFixMod;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;

public class SchematicProcessor {
    private static final String[] ALLOWED_TAGS = new String[]{"create:clipboard_pages", "create:clipboard_type"};
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final long RETRY_DELAY_MS = 300L;
    private static final Logger LOGGER = Logger.getLogger(SchematicProcessor.class.getName());

    public static boolean processSchematicFile(MinecraftServer server, Path file, String playerName) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                return SchematicProcessor.processSchematicFileInternal(server, file, playerName);
            }
            catch (Exception e) {
                if (attempt < 2 && SchematicProcessor.isRetryableException(e)) {
                    try {
                        Thread.sleep(300L * (long)(attempt + 1));
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                LOGGER.log(Level.WARNING, String.format("Failed to process schematic file %s for player %s: %s", file.getFileName(), playerName, e.getClass().getSimpleName()));
                continue;
            }
        }
        return false;
    }

    private static boolean isRetryableException(Exception e) {
        return e instanceof EOFException || e instanceof ZipException || e instanceof ReportedNbtException || e instanceof IOException && e.getMessage() != null && (e.getMessage().contains("EOF") || e.getMessage().contains("ZLIB") || e.getMessage().contains("being used by another process") || e.getMessage().contains("Unexpected end"));
    }

    private static boolean processSchematicFileInternal(MinecraftServer server, Path file, String playerName) throws Exception {
        if (!Files.exists(file, new LinkOption[0])) {
            return false;
        }
        long fileSize = Files.size(file);
        if (fileSize < 10L) {
            return false;
        }
        CompoundTag root = null;
        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.READ);
             FileLock lock = channel.tryLock(0L, Long.MAX_VALUE, true);){
            if (lock == null) {
                throw new IOException("File is being used by another process");
            }
            if (!SchematicProcessor.isValidNbtFile(file)) {
                throw new IOException("Invalid NBT file format");
            }
            try {
                root = NbtIo.readCompressed((Path)file, (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (ReportedNbtException e) {
                Throwable cause = e.getCause();
                if (cause instanceof EOFException || cause instanceof ZipException) {
                    throw new IOException("NBT file read error: " + cause.getMessage(), cause);
                }
                throw e;
            }
        }
        if (root == null) {
            return false;
        }
        boolean modified = false;
        boolean bannedContent = false;
        modified = SchematicProcessor.processNbtRecursively((Tag)root);
        bannedContent = SchematicProcessor.containsBannedKeywords(server, root);
        if (modified || bannedContent) {
            SchematicProcessor.handleAnomalousSchematic(server, file, playerName, root, modified, bannedContent);
            return true;
        }
        return false;
    }

    private static void handleAnomalousSchematic(MinecraftServer server, Path file, String playerName, CompoundTag root, boolean modified, boolean bannedContent) {
        try {
            Path anomalyDir = SchematicFixMod.ANOMALY_DIR.resolve(playerName);
            Files.createDirectories(anomalyDir, new FileAttribute[0]);
            Path backupFile = anomalyDir.resolve(file.getFileName());
            Files.copy(file, backupFile, StandardCopyOption.REPLACE_EXISTING);
            String logMsg = String.format("[Create Bugfix] Found anomalous schematic by player '%s': %s", playerName, file.getFileName());
            server.execute(() -> server.getPlayerList().getServer().sendSystemMessage((Component)Component.literal((String)logMsg)));
            if (bannedContent) {
                Files.write(file, new byte[0], new OpenOption[0]);
                return;
            }
            if (modified) {
                SchematicProcessor.writeNbtFilesSafely(root, file);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to handle anomalous schematic: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidNbtFile(Path file) {
        try {
            byte[] header = new byte[2];
            try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                int bytesRead = inputStream.read(header);
                if (bytesRead < 2) {
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl = (header[0] & 0xFF) == 31 && (header[1] & 0xFF) == 139;
                return bl;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private static void writeNbtFilesSafely(CompoundTag root, Path file) throws IOException {
        Path tempFile = file.getParent().resolve(String.valueOf(file.getFileName()) + ".tmp");
        try {
            NbtIo.writeCompressed((CompoundTag)root, (Path)tempFile);
            Files.move(tempFile, file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private static boolean processNbtRecursively(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            boolean modified = false;
            if (compound.contains("components", 10)) {
                modified |= SchematicProcessor.cleanComponents(compound.getCompound("components"));
            }
            for (String key : compound.getAllKeys()) {
                Tag child = compound.get(key);
                modified |= SchematicProcessor.processNbtRecursively(child);
            }
            return modified;
        }
        if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            boolean modified = false;
            for (Tag element : list) {
                modified |= SchematicProcessor.processNbtRecursively(element);
            }
            return modified;
        }
        return false;
    }

    private static boolean cleanComponents(CompoundTag components) {
        if (components == null || components.isEmpty()) {
            return false;
        }
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : components.getAllKeys()) {
            boolean allowed = false;
            for (String allowedTag : ALLOWED_TAGS) {
                if (!key.equals(allowedTag)) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            components.remove(key);
        }
        return !keysToRemove.isEmpty();
    }

    private static boolean containsBannedKeywords(MinecraftServer server, CompoundTag nbt) {
        if (!((Boolean)Config.ENABLE_KEYWORD_CHECK.get()).booleanValue()) {
            return false;
        }
        List bannedKeywords = (List)Config.BANNED_KEYWORDS.get();
        if (bannedKeywords.isEmpty()) {
            return false;
        }
        return SchematicProcessor.containsBannedKeywordsRecursive((Tag)nbt, bannedKeywords);
    }

    private static boolean containsBannedKeywordsRecursive(Tag tag, List<? extends String> bannedKeywords) {
        block4: {
            block5: {
                block3: {
                    if (!(tag instanceof CompoundTag)) break block3;
                    CompoundTag compound = (CompoundTag)tag;
                    for (String key : compound.getAllKeys()) {
                        if (!SchematicProcessor.containsBannedKeywordsRecursive(compound.get(key), bannedKeywords)) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(tag instanceof ListTag)) break block5;
                ListTag list = (ListTag)tag;
                for (Tag element : list) {
                    if (!SchematicProcessor.containsBannedKeywordsRecursive(element, bannedKeywords)) continue;
                    return true;
                }
                break block4;
            }
            if (!(tag instanceof StringTag)) break block4;
            StringTag stringTag = (StringTag)tag;
            String value = stringTag.getAsString().toLowerCase();
            for (String string : bannedKeywords) {
                if (!value.contains(string.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }
}

