/*
 * Decompiled with CFR 0.152.
 */
package com.example.schematicsfix;

import com.example.schematicsfix.SchematicProcessor;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;

public class SchematicWatcher {
    private final MinecraftServer server;
    private final Path baseDir;
    private WatchService watchService;
    private final Map<WatchKey, Path> watchKeys;
    private ExecutorService executor;
    private ScheduledExecutorService delayedExecutor;
    private volatile boolean running;
    private final Map<Path, Long> fileWriteTimes = new ConcurrentHashMap<Path, Long>();
    private static final long FILE_STABILIZATION_DELAY = 1000L;

    public SchematicWatcher(MinecraftServer server, Path baseDir) {
        this.server = server;
        this.baseDir = baseDir;
        this.watchKeys = new HashMap<WatchKey, Path>();
    }

    public void startWatching() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            this.executor = Executors.newSingleThreadExecutor();
            this.delayedExecutor = Executors.newScheduledThreadPool(2);
            this.running = true;
            this.registerDirectory(this.baseDir);
            this.executor.submit(this::watchLoop);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stopWatching() {
        this.running = false;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.delayedExecutor != null) {
            this.delayedExecutor.shutdownNow();
        }
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fileWriteTimes.clear();
    }

    private void watchLoop() {
        while (this.running) {
            WatchKey key;
            try {
                key = this.watchService.take();
            }
            catch (InterruptedException e) {
                break;
            }
            Path dir = this.watchKeys.get(key);
            if (dir == null) continue;
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent ev = SchematicWatcher.cast(event);
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                if (Files.isDirectory(child, new LinkOption[0])) {
                    if (kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                    try {
                        this.registerDirectory(child);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!child.toString().endsWith(".nbt")) continue;
                String playerName = dir.getFileName().toString();
                if (kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                this.fileWriteTimes.put(child, System.currentTimeMillis());
                this.delayedExecutor.schedule(() -> this.processFileIfReady(child, playerName), 1000L, TimeUnit.MILLISECONDS);
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.watchKeys.remove(key);
            if (!this.watchKeys.isEmpty()) continue;
            break;
        }
    }

    private void processFileIfReady(Path file, String playerName) {
        if (!this.running || !Files.exists(file, new LinkOption[0])) {
            this.fileWriteTimes.remove(file);
            return;
        }
        Long lastWriteTime = this.fileWriteTimes.get(file);
        if (lastWriteTime == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastWriteTime < 1000L) {
            this.delayedExecutor.schedule(() -> this.processFileIfReady(file, playerName), 1000L, TimeUnit.MILLISECONDS);
            return;
        }
        this.server.execute(() -> {
            try {
                SchematicProcessor.processSchematicFile(this.server, file, playerName);
            }
            finally {
                this.fileWriteTimes.remove(file);
            }
        });
    }

    private void registerDirectory(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        WatchKey key = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.watchKeys.put(key, dir);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path child : stream) {
                if (!Files.isDirectory(child, new LinkOption[0])) continue;
                this.registerDirectory(child);
            }
        }
    }

    private static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }
}

