/*
 * Decompiled with CFR 0.152.
 */
package com.example.schematicsfix.commands;

import com.example.schematicsfix.SchematicFixMod;
import com.example.schematicsfix.SchematicProcessor;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;

public class ScanAllCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"schematic-all").requires(source -> source.hasPermission(2))).executes(ctx -> ScanAllCommand.scanAllSchematics((CommandSourceStack)ctx.getSource())));
    }

    private static int scanAllSchematics(CommandSourceStack source) {
        MinecraftServer server = source.getServer();
        Path uploadedDir = SchematicFixMod.UPLOADED_DIR;
        if (!Files.exists(uploadedDir, new LinkOption[0])) {
            source.sendFailure((Component)Component.literal((String)"Uploaded schematics directory not found!"));
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"Starting schematic scan..."), true);
        AtomicInteger processedCount = new AtomicInteger();
        AtomicInteger anomalyCount = new AtomicInteger();
        server.execute(() -> {
            try (Stream<Path> paths = Files.walk(uploadedDir, new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".nbt")).forEach(file -> {
                    Path playerDir = file.getParent().getFileName();
                    if (playerDir != null) {
                        boolean modified = SchematicProcessor.processSchematicFile(server, file, playerDir.toString());
                        if (modified) {
                            anomalyCount.incrementAndGet();
                        }
                        processedCount.incrementAndGet();
                    }
                });
                String resultMsg = String.format("Scanned %d schematics, found %d anomalies", processedCount.get(), anomalyCount.get());
                source.sendSuccess(() -> Component.literal((String)resultMsg), true);
            }
            catch (IOException e) {
                source.sendFailure((Component)Component.literal((String)("Error scanning schematics: " + e.getMessage())));
            }
        });
        return 1;
    }
}

