/*
 * Decompiled with CFR 0.152.
 */
package com.cff1028.schematicsfix;

import com.cff1028.schematicsfix.SchematicFixMod;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="schematicsfix")
public class SchematicConfigCommand {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"schematic-config").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"reload").executes(SchematicConfigCommand::reloadConfig))).then(Commands.literal((String)"status").executes(SchematicConfigCommand::showStatus))).then(Commands.literal((String)"rules").executes(SchematicConfigCommand::showRules)));
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        SchematicFixMod mod = SchematicFixMod.getInstance();
        if (mod != null && mod.getNbtDetector() != null) {
            boolean success = mod.getNbtDetector().reloadConfig();
            int ruleCount = mod.getNbtDetector().getRuleCount();
            if (success) {
                source.sendSuccess(() -> Component.literal((String)("\u00a7aConfiguration reloaded successfully! " + ruleCount + " filter rules have been loaded.")), true);
                SchematicFixMod.LOGGER.info("Configuration reloaded successfully by {} with {} rules", (Object)source.getTextName(), (Object)ruleCount);
                return 1;
            }
            source.sendFailure((Component)Component.literal((String)"\u00a7cConfiguration reload failed! Please check the console log for more details."));
            return 0;
        }
        source.sendFailure((Component)Component.literal((String)"\u00a7cSchematicFix Mod was not initialized correctly and cannot reload the configuration."));
        return 0;
    }

    private static int showStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        SchematicFixMod mod = SchematicFixMod.getInstance();
        if (mod != null && mod.getNbtDetector() != null) {
            int ruleCount = mod.getNbtDetector().getRuleCount();
            boolean fileWatcherRunning = mod.isFileWatcherRunning();
            source.sendSuccess(() -> Component.literal((String)("\u00a76SchematicFix Mod Status:\n\u00a77- Filter rules loaded: \u00a7e" + ruleCount + "\n\u00a77- File Watcher Status: \u00a7e" + (fileWatcherRunning ? "Running" : "Not Running") + "\n\u00a77- Use \u00a7e/schematic-config reload \u00a77to reload configuration\n\u00a77- Use \u00a7e/schematic-config rules \u00a77to view loaded rules")), false);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"\u00a7cSchematicFix Mod was not initialized correctly."));
        return 0;
    }

    private static int showRules(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        SchematicFixMod mod = SchematicFixMod.getInstance();
        if (mod != null && mod.getNbtDetector() != null) {
            List<String> rules = mod.getNbtDetector().getRuleNames();
            if (rules.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)"\u00a76Loaded Rules:\n\u00a77No rules loaded"), false);
            } else {
                StringBuilder ruleList = new StringBuilder();
                for (int i = 0; i < rules.size(); ++i) {
                    if (i > 0) {
                        ruleList.append("\n");
                    }
                    ruleList.append("\u00a77- \u00a7e").append(rules.get(i));
                }
                source.sendSuccess(() -> Component.literal((String)("\u00a76Loaded Rules (" + rules.size() + "):\n" + ruleList.toString())), false);
            }
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"\u00a7cSchematicFix Mod was not initialized correctly."));
        return 0;
    }
}

