/*
 * Decompiled with CFR 0.152.
 */
package com.cff1028.schematicsfix;

import com.cff1028.schematicsfix.Config;
import com.cff1028.schematicsfix.FileWatcher;
import com.cff1028.schematicsfix.SchematicNBTDetector;
import java.io.IOException;
import java.util.List;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="schematicsfix")
public class SchematicFixMod {
    public static final String MODID = "schematicsfix";
    public static final Logger LOGGER = LogManager.getLogger();
    private static SchematicFixMod INSTANCE;
    private FileWatcher fileWatcher;
    private SchematicNBTDetector nbtDetector;
    private boolean fileWatcherRunning = false;

    public SchematicFixMod(IEventBus modEventBus, ModContainer modContainer) {
        INSTANCE = this;
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.addListener(this::onServerStarting);
        NeoForge.EVENT_BUS.addListener(this::onServerStopping);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static SchematicFixMod getInstance() {
        return INSTANCE;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Initializing Schematic Fix Mod");
        this.nbtDetector = new SchematicNBTDetector();
    }

    private void onServerStarting(ServerStartingEvent event) {
        try {
            this.fileWatcher = new FileWatcher(this.nbtDetector);
            this.fileWatcher.start();
            this.fileWatcherRunning = true;
            LOGGER.info("Schematic file watcher started successfully");
        }
        catch (IOException e) {
            LOGGER.error("Failed to start schematic file watcher", (Throwable)e);
            this.fileWatcherRunning = false;
        }
    }

    private void onServerStopping(ServerStoppingEvent event) {
        if (this.fileWatcher != null) {
            try {
                this.fileWatcher.stop();
                this.fileWatcherRunning = false;
                LOGGER.info("Schematic file watcher stopped successfully");
            }
            catch (IOException e) {
                LOGGER.error("Error stopping schematic file watcher", (Throwable)e);
            }
        }
    }

    public SchematicNBTDetector getNbtDetector() {
        return this.nbtDetector;
    }

    public boolean isFileWatcherRunning() {
        return this.fileWatcherRunning;
    }

    public List<String> getRuleNames() {
        return this.nbtDetector != null ? this.nbtDetector.getRuleNames() : List.of();
    }
}

